% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_filters.R
\name{boruta_filter}
\alias{boruta_filter}
\title{Boruta filter}
\usage{
boruta_filter(
  y,
  x,
  select = c("Confirmed", "Tentative"),
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{select}{Which type of features to retain. Options include "Confirmed"
and/or "Tentative".}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a named vector of variable
importance.}

\item{...}{Other arguments passed to \code{\link[Boruta:Boruta]{Boruta::Boruta()}}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} full output from \code{Boruta} is returned.
}
\description{
Filter using Boruta algorithm.
}
\details{
Boruta works differently from other filters in that it does not rank
variables by variable importance, but tries to determine relevant features
and divides features into Rejected, Tentative or Confirmed.
}
