% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{lm_filter}
\alias{lm_filter}
\title{Linear model filter}
\usage{
lm_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = NULL,
  rsq_cutoff = NULL,
  type = c("index", "names", "full")
)
}
\arguments{
\item{y}{Numeric or integer response vector}

\item{x}{Matrix of predictors. If \code{x} is a data.frame it will be turned into
a matrix. But note that factors will be reduced to numeric values, but a
full design matrix is not generated, so if factors have 3 or more levels,
it is recommended to convert \code{x} into a design (model) matrix first.}

\item{force_vars}{Vector of column names \code{x} which are incorporated into the
linear model.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p-values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p-value cut-off. P-values are calculated by t-statistic on
the estimated coefficient for the predictor being tested.}

\item{rsq_cutoff}{r^2 cutoff for removing predictors due to collinearity.
Default \code{NULL} means no collinearity filtering. Predictors are ranked based
on AIC from a linear model. If 2 or more predictors are collinear, the
first ranked predictor by AIC is retained, while the other collinear
predictors are removed. See \code{\link[=collinear]{collinear()}}.}

\item{type}{Type of vector returned. Default "index" returns indices, "names"
returns predictor names, "full" returns a matrix of p values.}
}
\value{
Integer vector of indices of filtered parameters (\code{type = "index"})
or character vector of names (\code{type = "names"}) of filtered parameters in
order of linear model AIC. Any variables in \code{force_vars} which are
incorporated into all models are listed first. If \code{type = "full"} a matrix
of AIC values, sigma, the residual standard error (see \link{summary.lm}),
t-statistic and p-values for the tested predictor is returned.
}
\description{
Linear models are fitted on each predictor, with inclusion of variable names
listed in \code{force_vars} in the model. Predictors are ranked by Akaike
information criteria (AIC) value, or can be filtered by the p-value on the
estimate of the coefficient for that predictor in its model.
}
