% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bacon.R
\name{read_bacon}
\alias{read_bacon}
\title{Function to read in defined Bacon outputs.}
\usage{
read_bacon(x, path = ".", add = FALSE, chron_name = "Bacon",
  as_default = TRUE, download = NULL, sections = NULL,
  age_field = "median", interp = TRUE)
}
\arguments{
\item{x}{A folder path that contains a Bacon \code{age} file.}

\item{path}{The location of the \code{Cores} folder.}

\item{add}{Should the results be added to an existing \code{download}? Defaults to \code{FALSE}.}

\item{chron_name}{The name for the chronology if the Bacon file is being added to a \code{download}.}

\item{as_default}{Should the chronology become the default?}

\item{download}{The target \code{download} if \code{add} is \code{TRUE}.}

\item{sections}{If there are multiple Bacon runs in a folder, identify the file by the number of sections in the run.}

\item{age_field}{Should the age be assigned to the \code{"median"} or the \code{"wmean"}?}

\item{interp}{If the depths don't match up, should we interpolate from the Bacon output? (default \code{TRUE})}
}
\description{
Reads in Bacon output and formats it for inclusion in a download object.
}
\details{
The function expects that you are in a working directory containing a "Cores" which would then contain output files from Bacon runs.  The output can either be added to an existing record (for example, replacing the default age model returned by Neotoma), or it can be loaded on its own.
If the depths for the loaded file do not match with the depths in the `download`'s `sample.meta` then the user can use the `interp` parameter to interpolate between depths.  This method uses linear interpolation.
}
\examples{
\dontrun{
# Download the record for Lake O' Pines:
lake_o_dl <- get_download(15925)

# This assumes that you have Bacon installed in a folder and have
# set it to your working directory.

write_agefile(lake_o_dl[[1]], path = ".", chronology = 1, 
              corename = "LAKEPINES", cal.prog = 'Bacon') 

source("Bacon.R") 

# These defaults just help the core run quickly, they're not 
# neccesarily good parameters.

Bacon("LAKEPINES", acc.mean = 10, 
      thick = 50, depths.file = TRUE, 
      suggest = FALSE, ask = FALSE)

lake_o_dl <- read_bacon("LAKEPINES", add = TRUE, 
                        download = download, sections = 17)

}
}
