% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_closest.R
\name{get_closest}
\alias{get_closest}
\title{Find the closest dataset records to a site, dataset or long/lat pair in Neotoma}
\usage{
get_closest(x, n, buffer, ...)
}
\arguments{
\item{x}{A vector long/lat pair, or a dataset, site or download.}

\item{n}{The number of records to return.}

\item{buffer}{The size of the buffer for dataset search (in kilometers)}

\item{...}{optional arguments to pass into \code{get_dataset}.}
}
\value{
This command returns a \code{dataset} or \code{dataset_list}, or NULL if no records exist within the bounding box.
}
\description{
Passing in a download object the function outputs a Bacon or Clam formatted file to a
user defined destination for age modelling with existing age-depth modeling software.
}
\examples{
\dontrun{
#  The point of pulling chronology tables is to re-build or examine the chronological 
#  information that was used to build the age-depth model for the core.
# Find the closest records to Madison, WI:
get_closest(x = c(-89.4012, 43.0731), n = 10, buffer = 5, datasettype = "pollen")
}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}, Andria Dawson \email{andria.dawson@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{API}
\keyword{Neotoma}
\keyword{Palaeoecology}

