% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publication.R
\name{get_publication.default}
\alias{get_publication.default}
\title{A function to get publications for sites or datasets in the Neotoma Database using the API.}
\usage{
\method{get_publication}{default}(x, contactid, datasetid, author, pubtype,
  year, search)
}
\arguments{
\item{x}{Numeric Publication ID value, either from \code{\link{get_dataset}} or known.}

\item{contactid}{Numeric Contact ID value, either from \code{\link{get_dataset}} or \code{\link{get_contact}}}

\item{datasetid}{Numeric Dataset ID, known or from \code{\link{get_dataset}}}

\item{author}{Character string for full or partial author's name.  Can include wildcards such as 'Smit*' for all names beginning with 'Smit'.}

\item{pubtype}{Character string, one of eleven allowable types, see \code{\link{get_table}}. For a list of allowed types run \code{get_table("PublicationTypes")}.}

\item{year}{Numeric publication year.}

\item{search}{A character string to search for within the article citation.}
}
\description{
The function takes the parameters, defined by the user, and returns a table with
   publication information from the Neotoma Paleoecological Database.
}

