% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackDataFilesParallel.R
\name{stackDataFilesParallel}
\alias{stackDataFilesParallel}
\title{Join data files in a unzipped NEON data package by table type}
\usage{
stackDataFilesParallel(folder, nCores = 1)
}
\arguments{
\item{folder}{The location of the data}

\item{nCores}{The number of cores to parallelize the stacking procedure. To automatically use the maximum number of cores on your machine we suggest setting 'nCores=parallel::detectCores()'. By default it is set to a single core. If the files are less than 25000 bytes the userdefined nCores will be overridden to a single core.}
}
\value{
One file for each table type is created and written.
}
\description{
Given a folder of unzipped files (unzipped NEON data file), do a full join of all data files, grouped by table type.
This should result in a small number of large files.
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Christine Laney \email{claney@battelleecology.org}
}
