% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement_detect.R
\name{measurement_detect}
\alias{measurement_detect}
\title{Internal function that makes sure for each time, position, and depth we have at least two data points for soil temp and soil h20, 3 for soil co2}
\usage{
measurement_detect(input_data)
}
\arguments{
\item{input_data}{Required. Nested data frame of merged soil water, temperature, co2, and pressure across different NEON locations and depths}
}
\value{
Data frame of fluxes from the timeperiod
}
\description{
Given a merged data frame of co2, water, and temperature:
1) Filters on QF measurement flags
2) Filters if we have at least 2 soil h20 and temperature measurements, 3 co2 measurements at each time, horizontal position, and vertical depth
3) Filters if we have at least 3 distinct measurements at each time and horizontal position
4) Returns the resulting data frame.

This internal function is created to speed up data processing.
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
based on code developed by Edward Ayres \email{eayres@battelleecology.org}
}
