% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_01_population.R
\name{safety_01_population}
\alias{safety_01_population}
\title{Safety-01 Populations}
\usage{
safety_01_population(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  eresponse_24_col
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{Column name containing the unique patient record
identifier.}

\item{incident_date_col}{Date or POSIXct column indicating the date of the
incident.}

\item{patient_DOB_col}{Date or POSIXct column for the patient’s date of birth}

\item{epatient_15_col}{Column containing age.}

\item{epatient_16_col}{Column for age units.}

\item{eresponse_05_col}{Column containing response mode codes (e.g., 911
response codes).}

\item{eresponse_24_col}{Column detailing additional response descriptors as
text.}
}
\value{
A list that contains the following:
\itemize{
\item a tibble with counts for each filtering step,
\item a tibble for each population of interest
\item a tibble for the initial population
\item a tibble for the total dataset with computations
}
}
\description{
Filters data down to the target populations for Safety-01, and categorizes
records to identify needed information for the calculations.

Identifies key categories related to 911 responses where "lights and sirens"
were not used in an EMS dataset. This function segments the data by age into
adult and pediatric populations.
}
\examples{
# create tables to test correct functioning

# patient table
  patient_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    incident_date = as.Date(c("2025-01-01", "2025-01-05",
                              "2025-02-01", "2025-01-01",
                              "2025-06-01")
                              ),
    patient_dob = as.Date(c("2000-01-01", "2020-01-01",
                            "2023-02-01", "2023-01-01",
                            "1970-06-01")
                            ),
    epatient_15 = c(25, 5, 2, 2, 55),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Years", "Years")

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    eresponse_05 = rep(2205001, 5),
    eresponse_24 = rep("No Lights or Sirens", 5)

  )

# Run the function
result <- safety_01_population(patient_scene_table = patient_table,
                              response_table = response_table,
                              erecord_01_col = erecord_01,
                              incident_date_col = incident_date,
                              patient_DOB_col = patient_dob,
                              epatient_15_col = epatient_15,
                              epatient_16_col = epatient_16,
                              eresponse_05_col = eresponse_05,
                              eresponse_24_col = eresponse_24
                        )

# show the results of filtering at each step
result$filter_process

}
\author{
Nicolas Foss, Ed.D., MS
}
