% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFObject.R
\docType{class}
\name{CFObject}
\alias{CFObject}
\title{CF base object}
\description{
This class is a basic ancestor to all classes that represent CF
objects, specifically data variables and axes. More useful classes use this
class as ancestor.
}
\details{
The fields in this class are common among all CF objects.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{NCvar}}{The \link{NCVariable} instance that this CF object represents.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{id}}{(read-only) The identifier of the CF object.}

\item{\code{name}}{(read-only) The name of the CF object.}

\item{\code{attributes}}{(read-only) A \code{data.frame} with the attributes of the CF object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFObject-new}{\code{CFObject$new()}}
\item \href{#method-CFObject-attribute}{\code{CFObject$attribute()}}
\item \href{#method-CFObject-print_attributes}{\code{CFObject$print_attributes()}}
\item \href{#method-CFObject-clone}{\code{CFObject$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF object instance from a variable in a netCDF
resource. This method is called upon opening a netCDF resource. It is
rarely, if ever, useful to call this constructor directly from the
console. Instead, use the methods from higher-level classes such as
\link{CFVariable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$new(nc_var)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The \link{NCVariable} instance upon which this CF object is
based.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFobject} instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-attribute}{}}}
\subsection{Method \code{attribute()}}{
Retrieve attributes of any CF object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$attribute(att, field = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{att}}{Vector of character strings of attributes to return.}

\item{\code{field}}{The field of the \code{data.frame} to return values from. This
must be "value" (default), "type" or "length".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of values from the \code{data.frame}, named with the \code{att}
value, \code{character(0)} if a name in \code{att} is not an attribute of this
object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-print_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-print_attributes}{}}}
\subsection{Method \code{print_attributes()}}{
Print the attributes of the CF object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$print_attributes(width = 50)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{The maximum width of each column in the \code{data.frame} when
printed to the console.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
