% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_help.R
\name{nbc4vaHelpFunctions}
\alias{nbc4vaHelpFunctions}
\title{Functions in nbc4va}
\usage{
nbc4vaHelpFunctions()
}
\description{
Functions in nbc4va
}
\section{About}{

This documentation page provides an organized list of the available functions in the nbc4va package and a brief
description of what they are used for.
}

\section{Utility Functions}{

\itemize{
  \item \strong{\code{\link{nbc4vaGUI}}}: web-based graphical user interface using \href{http://shiny.rstudio.com/}{shiny}
  \item \strong{\code{\link{nbc4vaIO}}}: convenient file input and output of model results
}
}

\section{Main Functions}{

\itemize{
  \item \strong{\code{\link{nbc}}}: fit a NBC model using training data to make predictions on testing data
  \item \strong{\code{\link{summary.nbc}}}: summarize \code{\link{nbc}} model results with informative metrics
  \item \strong{\code{\link{plot.nbc}}}: plot the top predicted causes of death by cause specific mortality fractions from a \code{\link{nbc}} model
}
}

\section{Wrapper Functions}{

\itemize{
  \item \strong{\code{\link{topCOD.nbc}}}: get the top cause of death predictions from \code{\link{nbc}}
  \item \strong{\code{\link{csmf.nbc}}}: get the predicted cause specific mortality fractions from \code{\link{nbc}}
}
}

\section{Extra Functions}{

\itemize{
  \item \strong{\code{\link{ova2nbc}}}: wrapper function for accepting \href{https://cran.r-project.org/package=openVA}{openVA} inputs to create a \code{\link{nbc}} model
}
}

\section{Help Functions}{

\itemize{
  \item \strong{\code{\link{nbc4vaHelpMethods}}}: help page on methodology and implementation of the package
  \item \strong{\code{\link{nbc4vaHelpData}}}: help page on training and testing data format in the package
  \item \strong{\code{\link{nbc4vaHelpBasic}}}: help page on running the package user interface and file input/output
  \item \strong{\code{\link{nbc4vaHelpAdvanced}}}: help page on running the main functions and methods in the package
  \item \strong{\code{\link{nbc4vaHelpDev}}}: developer help page on the coding structure and dependencies
}
}
\seealso{
Guide for package: \code{\link{nbc4va}}

Other help functions: \code{\link{nbc4vaHelpAdvanced}},
  \code{\link{nbc4vaHelpBasic}},
  \code{\link{nbc4vaHelpData}},
  \code{\link{nbc4vaHelpDev}},
  \code{\link{nbc4vaHelpMethods}}, \code{\link{nbc4vaHelp}}
}

