% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterator.R
\name{emr_monthly_iterator}
\alias{emr_monthly_iterator}
\alias{emr_yearly_iterator}
\title{Create an iterator that goes every year/month}
\usage{
emr_monthly_iterator(stime, etime = NULL, n = NULL)

emr_yearly_iterator(stime, etime = NULL, n = NULL)
}
\arguments{
\item{stime}{the date of the first point in machine format (use \code{emr_date2time})}

\item{etime}{end of time scope (can be \code{NULL} if \code{months} parameter is set)}

\item{n}{number of months / years}
}
\value{
an id time data frame that can be used as an iterator
}
\description{
Create an iterator that goes every year/month, from \code{stime}.
If \code{etime} is set, the iterator would go every year/month until the last point which is <= \code{etime}.
If \code{month} or \code{years} is set, the iterator would be set for every year/month
\code{n}times.
If both parameters are set, the iterator would go from \code{etime} until the early between \code{n}
times and \code{etime}.
}
\examples{
iter <- emr_monthly_iterator(emr_date2time(1, 1, 2002), emr_date2time(1, 1, 2017))
# note that the examples database doesn't include actual dates, so the results are empty
emr_extract("dense_track", iterator = iter, stime = 1, etime = 3)

iter <- emr_monthly_iterator(emr_date2time(1, 1, 2002), n = 15)
emr_extract("dense_track", iterator = iter, stime = 1, etime = 3)

}
