\name{Nardl-package}
\alias{Nardl-package}
\alias{Nardl}
\docType{package}
\title{
Nonlinear Cointegrating  Autoregressive Distributed Lag Model
}
\description{
Computes the nonlinear cointegrating autoregressive distributed lag model with p lags of the dependent variable and q lags of independent variables proposed by (Shin, Yu & Greenwood-Nimmo, 2014 <doi:10.1007/978-1-4899-8008-3_9>).
}
\details{
\tabular{ll}{
Package: \tab Nardl\cr
Type: \tab Package\cr
Version: \tab 1.2\cr
Date: \tab 2018-01-06\cr
License: \tab GPL-3\cr
}
In this package, we apply the ordinary least squares method to estimate the cointegrating nonlinear ARDL (NARDL) model in which short and long-run nonlinearities are introduced via positive and negative partial sum decompositions of the explanatory variables.Besides, we provide the CUSUM, CUSUMSQ model stability tests, model selection via aic, bic and rsqaured criteria and the dynamic multipliers plot.

}
\author{
Taha Zaghdoudi

Taha Zaghdoudi <zedtaha@gmail.com>
}


\references{

 Shin, Y., Yu, B., Greenwood-Nimmo, M. (2011): Modelling asymmetric cointegration and dynamic multipliers in a nonlinear ARDL framework. \emph{Working paper} \url{ http://ssrn.com/abstract=1807745}


}
\examples{
 # Load data
 data(fod)
 # Fit the nonlinear cointegrating  autoregressive distributed lag model
 reg<-nardl(food~inf,fod,p=3,q=3,ic="aic",graph=TRUE)
 summary(reg)

}
