% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{\%~>\%}
\alias{\%~>\%}
\title{Signal Forwarder}
\usage{
cv \%~>\% cv2
}
\arguments{
\item{cv}{a \sQuote{conditionVariable} object, from which to forward the
signal.}

\item{cv2}{a \sQuote{conditionVariable} object, to which the signal is
forwarded.}
}
\value{
Invisibly, \sQuote{cv2}.
}
\description{
Forwards signals from one \sQuote{conditionVariable} to another.
}
\details{
The condition value of \sQuote{cv} is initially reset to zero when this
operator returns. Only one forwarder can be active on a \sQuote{cv} at any
given time, and assigning a new forwarding target cancels any currently
existing forwarding.

Changes in the condition value of \sQuote{cv} are forwarded to \sQuote{cv2},
but only on each occassion \sQuote{cv} is signalled. This means that waiting
on \sQuote{cv} will cause a temporary divergence between the actual condition
value of \sQuote{cv} and that recorded at \sQuote{cv2}, until the next time
\sQuote{cv} is signalled.
}
\examples{
cva <- cv(); cvb <- cv(); cv1 <- cv(); cv2 <- cv()

cva \%~>\% cv1 \%~>\% cv2
cvb \%~>\% cv2

cv_signal(cva)
cv_signal(cvb)
cv_value(cv1)
cv_value(cv2)

}
