% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ctx_send_vec}
\alias{ctx_send_vec}
\title{Send Vector over Context (Async)}
\usage{
ctx_send_vec(context, ..., timeout)
}
\arguments{
\item{context}{a Context.}

\item{...}{one or more R objects to send (serialised) asynchronously.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}
}
\value{
A vector of zeros (invisibly) on success.
}
\description{
Send any number of R vectors asynchronously over a Context, with the ability
    to set (optional) send timeouts. Data will be sent as binary without R
    serialisation, hence appropriate for interfacing with external programs.
}
\details{
Will block if the send is in progress and has not yet completed -
    certain protocol / transport combinations may limit the number of messages
    that can be queued if they have yet to be received. Set a timeout to
    ensure the function returns under all conditions.
}
\examples{
req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
out <- ctx_send_vec(ctx, c(1.1, 2.2), c(3.3, 4.4), timeout = 1000)
out

close(req)
close(rep)

}
