% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-n-prop-miss.R
\name{add_n_miss}
\alias{add_n_miss}
\title{Add column containing number of missing data values}
\usage{
add_n_miss(data, ..., label = "n_miss")
}
\arguments{
\item{data}{a dataframe}

\item{...}{Variable names to use instead of the whole dataset. By default this
looks at the whole dataset. Otherwise, this is one or more unquoted
expressions separated by commas. These also respect the dplyr verbs
\code{starts_with}, \code{contains}, \code{ends_with}, etc. By default will add "_all" to
the label if left blank, otherwise will add "_vars" to distinguish that it
has not been used on all of the variables.}

\item{label}{character default is "n_miss".}
}
\value{
a dataframe
}
\description{
It can be useful when doing data analysis to add the number of missing data
points into your dataframe. \code{add_n_miss} adds a column named "n_miss",
which contains the number of missing values in that row.
}
\examples{

airquality \%>\% add_n_miss()
airquality \%>\% add_n_miss(Ozone, Solar.R)
airquality \%>\% add_n_miss(dplyr::contains("o"))


}
\seealso{
\code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}} \code{\link[=cast_shadow]{cast_shadow()}}
}
