% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pCop.R
\name{pCop}
\alias{pCop}
\title{Distribution function of archm class objects}
\usage{
pCop(copula, vector = FALSE, express = TRUE)
}
\arguments{
\item{copula}{an Archimedean copula (archm) class object.}

\item{vector}{logical. If false, returns a function or a character string with (u_1, u_2, ..., u_dim) as arguments, else,
just (u).}

\item{express}{logical. If false, returns a function, else, a character string.}
}
\value{
The distribution function in the form of either a function or a character string.
}
\description{
Distribution function of an Archimedean copula (archm) class object.
}
\examples{
cop <- Clayton(5, 2)
pCop(cop, vector = TRUE, express = TRUE)
pCop(cop, vector = FALSE, express = TRUE)

}
\seealso{
\link{rCop}, \link{Clayton}, \link{AMH}, \link{Gumbel}, \link{Frank}
}
\author{
Simon-Pierre Gadoury
}
