### --- Test setup ---

if(FALSE) {
  library("RUnit")
  library("nCal")
}

test.5PL <- function() {

tolerance=1e-5
tol.=1 # the function integrate() is going through some changes. the functions that depend on integrate() has tolerance set to a large number for now

RNGkind("Mersenne-Twister", "Inversion")
#RNGkind("Marsaglia-Multicarry", "Kinderman-Ramage") 


set.seed(1)
log.conc=log(1e4)-log(3)*9:0
n.replicate=2
fi=simulate1curve (p.eotaxin[1,], rep(log.conc,each=n.replicate), sd.e=0.3)
dat.std=data.frame(fi, expected_conc=exp(rep(log.conc,each=n.replicate)), analyte="test", 
    assay_id="assay1", sample_id=NA, well_role="Standard", dilution=rep(3**(9:0), each=n.replicate))
dat=dat.std
# second plate
fi=simulate1curve (p.eotaxin[2,], rep(log.conc,each=n.replicate), sd.e=0.3)
dat.std=data.frame(fi, expected_conc=exp(rep(log.conc,each=n.replicate)), analyte="test", 
    assay_id="assay2", sample_id=NA, well_role="Standard", dilution=rep(3**(9:0), each=n.replicate))
dat=rbind(dat, dat.std)


## 2018 Aug. cran submission returns an error
#out.norm = ncal(log(fi)~expected_conc, dat, bcrm.fit=TRUE, bcrm.model="norm",
#    return.fits = TRUE, plot.se.profile=F,
#    control.jags=list(n.iter=1e1, n.adapt=0))
#fit.norm=attr(out.norm, "fits")

## for some reason, the following check passes test on my machine, but cannot pass test on CRAN maintainer's machine
#checkEqualsNumeric(
#    get.curve.param.list (fit.norm$coef.samples[1,1:5*2])$b
#    , 
#    -0.7312957
#    , tolerance=1e-6)


checkEqualsNumeric(get.curve.param.list(p.eotaxin[1,])$b, -0.9155976, tolerance=tolerance)
checkEqualsNumeric(get.curve.param.list(p.eotaxin)$b[5:6], c(-0.7751437, -0.7762582), tolerance=tolerance)
checkEqualsNumeric(get.curve.param.list(p.eotaxin[1,c("logtao","b","c","d","f")])$e, 59.1-0.0276, tolerance=tolerance)


checkEqualsNumeric(
    FivePL.x.inv(c(1,11), p.eotaxin[1,])
    , c(0, Inf), tolerance=tolerance)
    
checkEqualsNumeric(
    FivePL.x.inv(8:9, p.eotaxin[1,])
    , c(135.5713, 327.9885), tolerance=tolerance)
    
checkEqualsNumeric(
    FivePL.x.inv(8:9, p.eotaxin[2,])
    , c(142.5312, 334.9337), tolerance=tolerance)
    
checkEqualsNumeric(
    FivePL.x.inv(8:9, p.eotaxin[1:2,])
    , c(135.5713, 334.9337), tolerance=tolerance)
    
checkEqualsNumeric(
    FivePL.x.inv(8, p.eotaxin[1:2,])
    , c(135.5713, 142.5312), tolerance=tolerance)

checkException(
    FivePL.x.inv(8:9, p.eotaxin[1:3,])
    )

checkEqualsNumeric(
    FivePL.x.inv.func(p.eotaxin[1,])(8:9)
    , c(135.5713, 327.9885), tolerance=tolerance)

checkEqualsNumeric(
    FivePL.x.inv.func(p.eotaxin[1:2,])(8:9)
    , c(135.5713, 334.9337), tolerance=tolerance)

checkEqualsNumeric(
    FivePL.x.inv.func(p.eotaxin[1:2,])(c(1,11))
    , c(0, Inf), tolerance=tolerance)

    
checkEqualsNumeric(FivePL.t(5, p.eotaxin[1,]), 8.118479, tolerance=tolerance)

p.decr = p.eotaxin[1,]
p.decr["b"] = -p.decr["b"]

checkEqualsNumeric(
    FivePL.t.inv(c(2,5,11), p.decr)
    , c(Inf, 5.820098, -Inf), tolerance=tolerance)

checkEqualsNumeric(
    FivePL.t.inv(c(2,5,11), p.eotaxin[1,])
    , c(-Inf, 2.33743, Inf), tolerance=tolerance)

checkEqualsNumeric(
    FivePL.t.inv.func(p.decr)(c(2,5,11))
    , c(Inf, 5.820098, -Inf), tolerance=tolerance)

checkEqualsNumeric(
    FivePL.t.inv.func(p.eotaxin[1,])(c(2,5,11))
    , c(-Inf, 2.33743, Inf), tolerance=tolerance)


p.4pl = p.eotaxin
p.4pl = p.4pl[,-match("f",colnames(p.4pl))]

checkException(
    FivePL.x(c(1,1e1,1e2,1e3,1e4), p.4pl)
)

checkEqualsNumeric(
      FourPL.x(c(1,1e1,1e2,1e3,1e4,1e5), p.4pl)
    , 
      FivePL.x(c(1,1e1,1e2,1e3,1e4,1e5), cbind(p.4pl,"f"=1))
    , tolerance=tolerance)

checkException(
    FivePL.x(8:9, p.eotaxin[1:3,])
    )

checkEqualsNumeric(
    FourPL.x.inv(c(2,5,11), p.4pl[1,])
    , 
    FivePL.x.inv(c(2,5,11), c(p.4pl[1,],"f"=1))
    , tolerance=tolerance)


checkEqualsNumeric(
    FourPL.t.func(p.4pl)(log(c(1,1e1,1e2,1e3,1e4,1e5)))
    ,
    FourPL.x((c(1,1e1,1e2,1e3,1e4,1e5)), p.4pl)
    , tolerance=tolerance)



checkEqualsNumeric(
    gh2cla(c("c"=1,"d"=10,"g"=4,"h"=4))
    ,
    c(-1.777778,  1, 10, 54.598150)
    , tolerance=tolerance)

checkEqualsNumeric(
    gh2cla(c("c"=1,"d"=10,"g"=4,"h"=4,"f"=1))
    ,
    c(-1.777778,  1, 10, 54.598150, 1)
    , tolerance=tolerance)

checkEqualsNumeric(
    cla2gh(c(b=-1.777778,  c=1, d=10, e=54.598150))
    ,
    c(1, 10, 4,  4.000001)
    , tolerance=tolerance)

checkEqualsNumeric(
    cla2gh(c(b=-1.777778,  c=1, d=10, e=54.598150, f=1))
    ,
    c(1, 10, 4,  4.000001, 1)
    , tolerance=tolerance)


checkEqualsNumeric(FivePL.t(5:6, p.eotaxin[1,]), c(8.118479, 9.178339), tolerance=tolerance)

checkEqualsNumeric(FivePL.t.func(p.eotaxin[1,])(5:6), c(8.118479, 9.178339), tolerance=tolerance)

checkEqualsNumeric(FivePL.x.inv(c(4,5,11), p.eotaxin[1,]), c(0,10.35459,Inf), tolerance=tolerance)



checkEqualsNumeric(
    get.abc(p.eotaxin[1,], p.eotaxin[2,], t.range=log(c(0.51,1e4)))
    , 
    0.04151633
    , tolerance=tol.)


checkEqualsNumeric(
    get.S1(p.eotaxin[1,], p.eotaxin[2,], t.range=log(c(0.51,1e4)))
    , 
    0.002697115
    , tolerance=tol.)


checkEqualsNumeric(
    get.S2(p.eotaxin[1,], p.eotaxin[2,], t.range=log(c(0.51,1e4)))
    , 
    17.48958
    , tolerance=tol.)


checkEqualsNumeric(
    get.abs.dev(p.eotaxin[1,], p.eotaxin[2,], t.range=log(c(0.51,1e4)), y.range=c(5,6))
    , 
    0.07903227
    , tolerance=tol.)


checkException(
    get.abs.dev(p.eotaxin[1,], p.eotaxin[2,], t.range=log(c(0.51,1e4)), y.range=c(1,11))
    )




}
