% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{mc_info_join}
\alias{mc_info_join}
\title{Get joining info table}
\usage{
mc_info_join(data, comp_sensors = NULL)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{comp_sensors}{parameter for \code{\link[=mc_join]{mc_join()}} function (default NULL)}
}
\value{
A data.frame with the following columns:
\itemize{
\item locality_id - The ID of the locality.
\item count_loggers - Number of loggers before the join operation.
\item count_joined_loggers - Number of loggers after the join operation.
\item count_data_conflicts - Number of different values in overlapping sensors.
\item count_errors - Number of join-related errors. An error occurs when all sensors of the loggers have different names.
}
}
\description{
This function returns a data.frame that contains information about the join operations.
Although this function performs the join process, it only returns an overview table,
not the actual joined data.
}
\details{
This function is designed to work only with
myClim objects in \strong{Raw-format}, where the loggers are organized at localities.
In \strong{Agg-format}, myClim objects do not support loggers; sensors are directly connected to the locality.
See \link{myClim-package}. \code{mc_info_join} does not work in Agg-format.
}
