% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{mc_reshape_wide}
\alias{mc_reshape_wide}
\title{Export values to wide table}
\usage{
mc_reshape_wide(data, localities = NULL, sensors = NULL)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{localities}{names of localities; if NULL then all (default NULL)}

\item{sensors}{names of sensors; if NULL then all (default NULL) see \code{names(mc_data_sensors)}}
}
\value{
data.frame with columns:
\itemize{
\item datetime
\item locality1_sensor1
\item ...
\item ...
\item localityn_sensorn
}
}
\description{
This function converts myClim object to the R data.frame with values of sensor in wide format.
}
\details{
First column of the output data.frame is datetime followed by the
columns for every sensor. Name of the column is in format:
\itemize{
\item localityid_serialnumber_sensorname for Raw-format
\item localityid_sensorname for Agg-format
}

The less complex wide table is returned when exporting single sensor ascross localities.
}
\examples{
example_tms_wideformat <- mc_reshape_wide(mc_data_example_raw, c("A6W79", "A2E32"),
                                          c("TMS_T1", "TMS_T2"))
}
