% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_model.R
\name{extract_model}
\alias{extract_model}
\title{Extract Model}
\usage{
extract_model(mxFDAobject, metric, type, model_name)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA}}

\item{metric}{metric functional PCA data to extract, e.g. 'uni k'}

\item{type}{one of "cox", "mcox", or "sofr" to specify the type of model to extract}

\item{model_name}{character string of the model name to retrieve}
}
\value{
fit functional model
}
\description{
Currently only extracts functional cox models not mixed functional cox models.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian mxFDA object
data('ovarian_FDA')

#run the lfcm model
ovarian_FDA = run_fcm(ovarian_FDA, model_name = "fit_lfcm",
                      formula = survival_time ~ age, event = "event",
                      metric = "uni g", r = "r", value = "fundiff",
                      analysis_vars = c("age", "survival_time"),
                      afcm = FALSE)

#extract model
mod = extract_model(ovarian_FDA, 'uni g', 'cox', 'fit_lfcm')

}
\author{
Alex Soupir \email{alex.soupir@moffitt.org}
}
