/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.graph;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;

public class GraphIO {
    private File nodeIn;
    private File edgeIn;
    private File signalIn;
    private Map<String, Node> nodeNames;
    private Map<Unit, String> unitMap;
    private Signals signals;
    private Map<String, Integer> signalNames;
    private String inf = "inf";
    private String nodeOut;
    private String edgeOut;

    public GraphIO(File nodeIn, File edgeIn, File signalIn, String outDir) {
        this.nodeIn = nodeIn;
        this.edgeIn = edgeIn;
        this.signalIn = signalIn;
        this.nodeOut = outDir + "/" + nodeIn.getName() + ".out";
        this.edgeOut = outDir + "/" + edgeIn.getName() + ".out";
        this.signals = new Signals();
        this.nodeNames = new LinkedHashMap<String, Node>();
        this.unitMap = new HashMap<Unit, String>();
        this.signalNames = new HashMap<String, Integer>();
    }

    /*
     * Exception decompiling
     */
    public Graph read() throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseNodes(LineNumberReader reader, Graph graph) throws ParseException, IOException {
        String line;
        int cnt = 1;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer;
            if (line.startsWith("#") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            String node = tokenizer.nextToken();
            try {
                Node vertex = new Node(cnt++);
                if (this.nodeNames.containsKey(node)) {
                    throw new ParseException("Duplicate node " + node, 0);
                }
                this.nodeNames.put(node, vertex);
                graph.addVertex(vertex);
                this.processSignals(vertex, tokenizer);
                this.unitMap.put(vertex, node);
            }
            catch (ParseException e) {
                throw new ParseException(e.getMessage() + "node file, line", reader.getLineNumber());
            }
        }
    }

    private void parseEdges(LineNumberReader reader, Graph graph) throws ParseException, IOException {
        String line;
        int cnt = 1;
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer;
            if (line.startsWith("#") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            String first = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                throw new ParseException("Wrong edge format at line", reader.getLineNumber());
            }
            String second = tokenizer.nextToken();
            try {
                if (!this.nodeNames.containsKey(first) || !this.nodeNames.containsKey(second)) {
                    throw new ParseException("There's no such vertex in edge list at line", reader.getLineNumber());
                }
                Edge edge = new Edge(cnt++);
                Node from = this.nodeNames.get(first);
                Node to = this.nodeNames.get(second);
                graph.addEdge(from, to, edge);
                List<String> tokens = this.processSignals(edge, tokenizer);
                this.unitMap.put(edge, first + "\t" + second + "\t" + String.join((CharSequence)",", tokens));
            }
            catch (ParseException e) {
                throw new ParseException(e.getMessage() + "edge file, line", reader.getLineNumber());
            }
        }
    }

    private List<String> processSignals(Unit unit, StringTokenizer tokenizer) throws ParseException {
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        if (!tokens.isEmpty()) {
            for (String token : tokens) {
                if (this.signalNames.containsKey(token)) {
                    int signal = this.signalNames.get(token);
                    this.signals.add(unit, signal);
                    continue;
                }
                this.signalNames.put(token, this.signals.addAndSetWeight(unit, 0.0));
            }
        } else {
            throw new ParseException("Expected signal name: ", 0);
        }
        return tokens;
    }

    private void parseSignals(LineNumberReader reader) throws IOException, ParseException {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                double weight2;
                StringTokenizer tokenizer;
                if (line.startsWith("#") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
                String signal = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    throw new ParseException("Expected weight of signal at line ", reader.getLineNumber());
                }
                String w = tokenizer.nextToken();
                double d = weight2 = w.equals(this.inf) ? Double.POSITIVE_INFINITY : Double.parseDouble(w);
                if (!this.signalNames.containsKey(signal)) continue;
                int set = this.signalNames.get(signal);
                this.signals.setWeight(set, weight2);
                if (!(weight2 < 0.0) || this.signals.set(set).size() <= 1) continue;
                throw new ParseException("Repeating negative signal at line ", reader.getLineNumber());
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Wrong format of weight of signal at line", reader.getLineNumber());
        }
    }

    public void write(List<Unit> units) throws IOException {
        if (units == null) {
            units = new ArrayList<Unit>();
        }
        try (PrintWriter nodeWriter = new PrintWriter(this.nodeOut);
             PrintWriter edgeWriter = new PrintWriter(this.edgeOut);){
            for (Unit unit : units) {
                if (!this.unitMap.containsKey(unit)) {
                    throw new IllegalStateException();
                }
                if (unit instanceof Node) {
                    nodeWriter.println(this.unitMap.get(unit));
                    continue;
                }
                edgeWriter.println(this.unitMap.get(unit));
            }
        }
    }

    public Signals getSignals() {
        return this.signals;
    }
}

