% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-mwaved.R
\name{summary.mWaveD}
\alias{summary.mWaveD}
\title{Summary Output for the mWaveD object}
\usage{
\method{summary}{mWaveD}(object, ...)
}
\arguments{
\item{object}{A mWaveD object which is a list containing all the information for a multichannel 
deconvolution analysis produced by the \code{\link{multiWaveD}} function.}

\item{...}{Arguments to be passed to methods.}
}
\value{
Text output giving summary information of the input and output analysis including, \itemize{
\item Degree of Meyer wavelet used in the analysis.
\item Number of observations, within each channel and number of channels present.
\item Resolution levels used (j0 to j1)
\item Blur type assumed in the analysis (direct, smooth or box.car)
\item Matrix summarising the noise levels in each channel (and Fourier decay information for the smooth case)
\item Summaries of the severity of the thresholding applied amongst the resolutions.
}
}
\description{
Gives some numerical summaries of a \code{mWaveD} object.
}
\examples{
library(mwaved)
# Simulate the multichannel doppler signal.
m <- 3
n <- 2^10
t <- (1:n)/n
signal <- makeDoppler(n)
# Create multichannel version with smooth blur
shape <- seq(from = 0.5, to = 1, length = m)
scale <- rep(0.25, m)
G <- gammaBlur(n, shape, scale)
X <- blurSignal(signal, G)
# Add noise with custom signal to noise ratio
SNR <- c(10,15,20)
E <- multiNoise(n, sigma = sigmaSNR(X, SNR), alpha = c(0.5, 0.75, 1))
# Create noisy & blurred multichannel signal
Y <- X + E
mWaveDObject <- multiWaveD(Y, G)
summary(mWaveDObject)
}
\seealso{
\code{\link{multiWaveD}}
}

