## ----set-options, echo = FALSE------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", dev = "png", fig.width = 7, fig.height = 3.5, message = FALSE, warning = FALSE)
options(width = 80, tibble.width = Inf)

## -----------------------------------------------------------------------------
library("mvp",quietly=TRUE)
(p <- as.mvp("3 x y + z^3 + x y^6 z"))

## -----------------------------------------------------------------------------
(M <- as.mvp("3 stoat goat^6 -4 + 7 stoatboat^3 bloat -9 float boat goat gloat^6"))
dput(M)

## -----------------------------------------------------------------------------
print(M,order="lex", varorder=c("stoat","goat","boat","bloat","gloat","float","stoatboat"))

## -----------------------------------------------------------------------------
(S1 <- rmvp(5,2,2,4))
(S2 <- rmvp(5,2,2,4))
S1 + S2
S1 * S2
S1^2

## -----------------------------------------------------------------------------
(S3 <- as.mvp("x + 5 x^4 y + 8 y^2 x z^3"))

## -----------------------------------------------------------------------------
subs(S3, x = 1)

## -----------------------------------------------------------------------------
subs(S3, x = 1, y = 2, z = 3)

## -----------------------------------------------------------------------------
subs(as.mvp("a+b+c"), a="x^6")

## -----------------------------------------------------------------------------
subs(as.mvp("a+b+c"), a="x^6",x="1+a")
subs(as.mvp("a+b+c"), x="1+a",a="x^6")

## -----------------------------------------------------------------------------
as.mvp("a+b") %>% subs(a="a^2+b^2") %>% subs(b="x^6")

## -----------------------------------------------------------------------------
(S <- as.mvp("a + 5 a^5*b^2*c^8 -3 x^2 a^3 b c^3"))
deriv(S, letters[1:3])
deriv(S, rev(letters[1:3]))  # should be the same.

## -----------------------------------------------------------------------------
aderiv(S, a = 3, b = 1, c = 2)

## -----------------------------------------------------------------------------
S %<>% aderiv(a=1,b=2) %>% subs(c="x^4") %>% `+`(as.mvp("o^99"))
S

## -----------------------------------------------------------------------------
(X <- as.mvp("1+x+x^2 y")^3)
taylor(X,3)        # terms with total power <= 3
taylor(X,3,"x")    # terms with power of x <= 3
onevarpow(X,3,"x") # terms with power of x == 3

## -----------------------------------------------------------------------------
## second order taylor expansion of f(x)=sin(x+y) for x=1.1, about x=1:
sinxpy <- horner("x+y",c(0,1,0,-1/6,0,+1/120,0,-1/5040))  # sin(x+y)
dx <- as.mvp("dx")
t2 <- sinxpy  + aderiv(sinxpy,x=1)*dx + aderiv(sinxpy,x=2)*dx^2/2
(t2 %<>% subs(x=1,dx=0.1))  # (Taylor expansion of sin(y+1.1), left in symbolic form)
(t2 %>% subs(y=0.3))  - sin(1.4)  # numeric; should be small

## -----------------------------------------------------------------------------
(p <- as.mvp("1+x+x^2 y"))
invert(p)

## -----------------------------------------------------------------------------
p + as.mvp("z^6")

## -----------------------------------------------------------------------------
knight(2)

## -----------------------------------------------------------------------------
constant(knight(4)^4)

## -----------------------------------------------------------------------------
library("spray")
library("mpoly")
n <- 100
k <- kahle(n, r = 3, p = 1:3, symbols = paste0("x", sprintf("%03d", 1:n)))

## -----------------------------------------------------------------------------
library("microbenchmark")

spray_k <- mvp_to_spray(k)
microbenchmark( k^2, spray_k^2 )

