#' @name mvMonitoring
#'
#' @title A Package for Multivariate Statistical Process Monitoring
#'
#' @description The \code{mvMonitoring} package has four main functions for
#'   external use, all of which begin with the string "msp" (for "multivariate
#'   statistical process") followed by the function use. Functions without this
#'   "msp" key are primarily internal functions. They are available to see and
#'   use, but will largely be uneccesary to call in common workflows.
#'
#' @section \code{mvMonitoring} external functions:
#'   \itemize{
#'     \item{\code{\link{mspProcessData}} - }{A function for synthetic process
#'       data generation. Use this data to test new process monitoring methods.
#'     }
#'     \item{\code{\link{mspTrain}} - }{A function to take in observations for
#'       training under normal conditions, and to return the training summary
#'       fromt these observations.
#'     }
#'     \item{\code{\link{mspMonitor}} - }{A function to take in real-time
#'       process observations and detect system anomalies based on the training
#'       summary returned by \code{\link{mspTrain}}.
#'     }
#'     \item{\code{\link{mspWarning}} - }{A function to take in observations
#'       returned by \code{\link{mspMonitor}} and check for alarms by
#'       measuring sequential anomalies. This function will also be equipped to
#'       send SMS notifications to process technicians in future versions.
#'     }
#'   }
#'
#' @docType package
#' @name mvMonitoring

NULL
