% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{attachMutType}
\alias{attachMutType}
\title{Attach Mutation Types.}
\usage{
attachMutType(mutData, ref_colName = "reference_allele",
  var_colName = "variant_allele", var2_colName = NULL,
  context_colName = "context", format = 1, mutType_dict = "alexa",
  mutType_colName = "mutType")
}
\arguments{
\item{mutData}{data.frame including information about DNA mutations}

\item{ref_colName}{string, pointing to the column with information about the sequence of the "reference_allele"}

\item{var_colName}{string, pointing to the column with information about the sequence of the "variant_allele"}

\item{var2_colName}{string (optional), pointing to the column with information about the 
sequence of a second "variant_allele". Can be NULL}

\item{context_colName}{string, pointing to the column with information about the nucleotidic "context"}

\item{format}{integer, indicates the desired mutation type format: (1) N[R>V]N; (2) NN.R>V; (3) R.V[NRN][NVN]}

\item{mutType_dict}{string, indicates the dictionary to be used for simplifying reverse-complement identical mutation types.
It is recommended to use the standard dictionary from COSMIC, by selecting the default value, i.e. "alexa".}

\item{mutType_colName}{string, column name of the new column added to the data.frame where mutTypes are stored.}
}
\value{
a data.frame including a new column with mutation Types.
}
\description{
Modify a data.frame carrying information about DNA mutation, and add a new column that 
stores formatted multi-nucleotide types.
}
\details{
This function is part of the user-interface set of tools included in mutSignatures. This is an exported function.
}
\examples{
 
A <- data.frame(REF = c("A", "T", "G"), 
                VAR = c("G", "C", "C"), 
                CTX = c("TAG", "GTG", "CGA"), 
                stringsAsFactors = FALSE)
mutSignatures::attachMutType(mutData = A, ref_colName = "REF", 
                             var_colName = "VAR", context_colName = "CTX")
      
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
