% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{rotate}
\alias{rotate}
\title{Circular rotation of an ordered tuple}
\usage{
rotate(x, n = 1, transpose_up = FALSE, edo = 12)
}
\arguments{
\item{x}{Vector to be rotated}

\item{n}{Number of positions the vector should be rotated left.
Defaults to \code{1}. May be negative.}

\item{transpose_up}{Boolean, defaults to \code{FALSE} which leaves entries
unchanged. If set to \code{TRUE}, elements moved from the head to the tail
of the vector are increased in value by \code{edo}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
(Rotated) vector of same length as x
}
\description{
Changes which element of a circularly-ordered series is in the first
position without otherwise changing the order. Used primarily to generate
the modes of a scale. Single application moves one element from the
beginning of a tuple to the end.
}
\examples{
rotate(c(0, 2, 4, 5, 7, 9, 11), n=2)
rotate(c(0, 2, 4, 5, 7, 9, 11), n=-2)
rotate(c(0, 2, 4, 5, 7, 9, 11), n=2, transpose_up=TRUE)
rotate(c(0, 2, 4, 5, 7, 9, 11), n=2, transpose_up=TRUE, edo=15)
rotate(c("father", "charles", "goes", "down", "and", "ends", "battle"),
  n=4)
}
