% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_indep_com.R
\name{test_indep_com}
\alias{test_indep_com}
\title{Pseudo pseudolikelihood ratio test for dependent communities}
\usage{
test_indep_com(
  X,
  K1 = NULL,
  K2 = NULL,
  nperm = 200,
  step = 0.001,
  maxiter = 1000,
  parallel = FALSE
)
}
\arguments{
\item{X}{Multi-view data with two views; a list of two n x n adjacency matrices.}

\item{K1}{An optional argument containing the number of communities in View 1.
If left out, then the number of communities is chosen with the method of 
Le and Levina (2015).}

\item{K2}{An optional argument containing the number of communities in View 2.
If left out, then the number of communities is chosen with the method of 
Le and Levina (2015).}

\item{nperm}{An integer specifying the number of permutations to
use for the permutation procedure. The default number is 200.}

\item{step}{A numeric value containing the fixed step size to be used in the optimization
algorithm for estimating Pi. The default step size is 0.001.}

\item{maxiter}{A numeric value containing the maximum number of iterations to run in
the optimization algorithm. The default maximum is 1000.}

\item{parallel}{An optional argument; if true, do parallel computing using the 
doParallel package}
}
\value{
A list containing the following output components:
\item{K1}{The number of communities in view 1}
\item{K2}{The number of communities in view 2}
\item{Pi.est}{The estimated Pi matrix}
\item{P2LRstat}{The pseudo likelihood ratio test statistic}
\item{pval}{The p-value}
\item{modelfit1}{The parameter estimates and community assignment estimates from View 1.}
\item{modelfit2}{The parameter estimates and community assignment estimates from View 2.}
}
\description{
Implements the pseudo pseudolikelihood ratio test described in Section 3 of
Gao et. al. (2019) "Testing for Association in Multi-View Network Data"
for testing for dependence between communities in two network data views.
Fits stochastic block models in each view.
}
\examples{
set.seed(1)
n <- 50
Pi <- diag(c(0.5, 0.5))
theta1 <- rbind(c(0.5, 0.1), c(0.1, 0.5))
theta2 <- cbind(c(0.1, 0.5), c(0.5, 0.1))

# 50 draws from a multi-view SBM with perfectly dependent communities
dat <- mv_sbm_gen(n, Pi, theta1, theta2)

# Test H0: communities are independent
# Data was generated under the alternative hypothesis 
results <- test_indep_com(dat$data, nperm=25)
results$pval

}
\references{
Amini, A. A., Chen, A., Bickel, P. J., & Levina, E. (2013). Pseudo-likelihood methods 
for community detection in large sparse networks. The Annals of Statistics, 41(4), 2097-2122.

Gao, L.L., Witten, D., Bien, J. Testing for Association in Multi-View Network Data, preprint. 

Le, C. M., & Levina, E. (2015). Estimating the number of communities 
in networks by spectral methods. arXiv preprint arXiv:1507.00827.
}
