% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{total.multivariance}
\alias{total.multivariance}
\title{total distance multivariance}
\usage{
total.multivariance(x, vec = NA, lambda = 1, Nscale = TRUE,
  Escale = TRUE, ...)
}
\arguments{
\item{x}{either a data matrix or an array of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is an array, these are the indexes for which the multivariance is calculated. The default is all columns and all indicies, respectively.}

\item{lambda}{a scaling parameter >0. Each k-tuple multivariance gets weight \code{lambda^(n-k)}.}

\item{Nscale}{if \code{TRUE} the multivariance is scaled up by the sample size (and thus it is exactly as required for the test of independence). This is only used if \code{correlation = FALSE}.}

\item{Escale}{if \code{TRUE} then it is scaled by the number of multivariances which are theoretically summed up (in the case of independence this yields for normalized distance matrices an estimator with expectation 1)}

\item{...}{these are passed to \code{\link{cdms}} (which is only invoked if \code{x} is a matrix)}
}
\description{
computes the total distance multivariance for the samples with the given index.
It uses the global array of distance matrices.
}
\details{
For details see the references given in the \link[=multivariance-package]{package documentation}.
}
\examples{
total.multivariance(matrix(rnorm(100*3),ncol = 3)) #independent sample
total.multivariance(coins(100)) #dependent sample which is 2-independent

}
