% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length_of_stay.R
\name{length_of_stay}
\alias{length_of_stay}
\title{Estimates length of stay}
\usage{
length_of_stay(models, newdata, trans_mat, times, start_state = 1,
  tcovs = NULL, N = 1e+05, M = 1000, ci = FALSE,
  ci_margin = 0.95, agelimit = FALSE, agecol = "age",
  agescale = 365.25)
}
\arguments{
\item{models}{List of \code{flexsurvreg} objects.}

\item{newdata}{Data frame with covariates of individual to simulate times for. Must contain all fields
required by models.}

\item{trans_mat}{Transition matrix, such as that used in \code{mstate}.}

\item{times}{Times at which to estimate length of stay.}

\item{start_state}{Starting state. Either number or character name in \code{trans_mat}.}

\item{tcovs}{As in \code{flexsurv::pmatrix.simfs}, this is the names of covariates that need to be
incremented by the simulation clock at each transition, such as age when modelled as age at state entry.}

\item{N}{Number of times to repeat the individual}

\item{M}{Number of times to run the simulations in order to obtain confidence interval estimates.}

\item{ci}{Whether to calculate confidence intervals. See \code{flexsurv::pmatrix.simfs} for details.}

\item{ci_margin}{Confidence interval range to use if \code{ci} is set to \code{TRUE}.}

\item{agelimit}{Whether to automatically assign people to an 'early death' state.
This is useful as otherwise individuals can be assigned unrealistic time-to-events due to the
nature of sampling times from a random number distribution.
If this value is \code{FALSE} then no limit is applied, otherwise provide the time-limit
to be used. This limit must be in the same time-scale as the time-to-event models.}

\item{agecol}{The name of the column in \code{newdata} that holds an individual's age.}

\item{agescale}{Any multiplication to be applied to the age covariate to put it onto the same
time-scale as the simulation. This is often useful as time-to-event may be measured on a day-based
time-scale while age is typically measured in years.}
}
\value{
A data frame containing length of stay estimates.
}
\description{
Estimates length of stay in each state of an individual's passage
through a multi-state model
by discrete event simulation.
}
\examples{

library(multistateutils)
library(mstate)
library(flexsurv)

# Convert data to long
data(ebmt3)
tmat <- trans.illdeath()
long <- msprep(time=c(NA, 'prtime', 'rfstime'),
               status=c(NA, 'prstat', 'rfsstat'),
               data=ebmt3,
               trans=tmat,
               keep=c('age', 'dissub'))

# Fit parametric models
models <- lapply(1:3, function(i) {
    flexsurvreg(Surv(time, status) ~ age + dissub, data=long, dist='weibull')
})

# New individual to estimate transition probabilities for
newdata <- data.frame(age="20-40", dissub="AML")

# Estimate length of stay in each state after a year, given starting in state 1
length_of_stay(models,
               newdata=newdata,
               tmat, times=365.25,
               start=1)

}
