% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R, R/ops.R
\name{reduce}
\alias{reduce}
\alias{reduce_}
\title{Summarise data (with local reduction)}
\usage{
reduce(.self, ..., auto_compact = NULL)

reduce_(.self, ..., .dots, auto_compact = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{...}{Additional parameters}

\item{auto_compact}{Compact data after operation}

\item{.dots}{Workaround for non-standard evaluation}
}
\value{
Data frame
}
\description{
\code{summarise} is used to summarise data on each node: \code{reduce} is then used to ensure that there's one overall summary
}
\details{
When data have not been grouped, calling \code{summary(...)} will result
in each node summarising the data it has available. This means that if
there are 3 nodes in the cluster, then there will be 3 summary values.
\code{reduce} is used to bring all those together to a single value.
}
\examples{
\donttest{
dat <- Multiplyr (x = 1:100)
dat \%>\% summarise (N = length(x))
dat \%>\% shutdown()

dat <- Multiplyr (x = 1:100)
dat \%>\% summarise (N = length(x)) \%>\% reduce(N = sum(N))
dat \%>\% shutdown()
}
}
\seealso{
Other data manipulations: \code{\link{mutate}},
  \code{\link{nsa}}, \code{\link{summarise}},
  \code{\link{transmute}}, \code{\link{within_group}},
  \code{\link{within_node}}
}

