% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochdom_Ab.R
\name{stochdom_Ab}
\alias{stochdom_Ab}
\title{Ab-Representation for Stochastic Dominance of Histogram Bins}
\usage{
stochdom_Ab(bins, conditions = 2, order = "<")
}
\arguments{
\item{bins}{number of bins of histogram}

\item{conditions}{number of conditions}

\item{order}{order constraint on the random variables across conditions.
The default \code{order="<"} implies that the random variables increase across
conditions (implying that the cdfs decrease: \eqn{F_1(t) > F_2(t)}).}
}
\description{
Provides the necessary linear equality constraints to test stochastic dominance
of continuous distributions, that is, whether the cumulative density functions
\eqn{F} satisfy the constraint \eqn{F_1(t) < F_2(t)} for all \eqn{t}.
}
\examples{
stochdom_Ab(4, 2)
stochdom_Ab(4, 3)
}
\references{
Heathcote, A., Brown, S., Wagenmakers, E. J., & Eidels, A. (2010). Distribution-free tests of stochastic dominance for small samples. Journal of Mathematical Psychology, 54(5), 454-463. \doi{10.1016/j.jmp.2010.06.005}
}
\seealso{
\code{\link{stochdom_bf}} to obtain a Bayes factor directly.
}
