% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_inside.R
\name{find_inside}
\alias{find_inside}
\title{Find a Point/Parameter Vector Within a Convex Polytope}
\usage{
find_inside(
  A,
  b,
  V,
  options = NULL,
  random = FALSE,
  probs = TRUE,
  boundary = 1e-05
)
}
\arguments{
\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}

\item{options}{optional: number of options per item type (only for \eqn{A x \leq b} representation).
Necessary to account for sum-to-one constraints within multinomial
distributions (e.g., p_1 + p_2 + p_3 <= 1).
By default, parameters are assumed to be independent.}

\item{random}{if \code{TRUE}, random starting values in the interior are generated.
If \code{FALSE}, the center of the polytope is computed using linear programming.}

\item{probs}{only for \code{A*x<b} representation: whether to add
inequality constraints that the variables are probabilities (nonnegative and
sum to 1 within each option)}

\item{boundary}{constant value \eqn{c} that is subtracted on the right-hand side
of the order constraints, \eqn{A x \leq b - c}. This ensuresa that the
resulting point is in the interior of the polytope and
not at the boundary, which is important for MCMC sampling.}
}
\description{
Finds the center/a random point that is within the convex polytope defined by the
linear inequalities \code{A*x <= b}  or by the convex hull over the vertices in the matrix \code{V}.
}
\details{
If vertices \code{V} are provided, a convex combination of the vertices is returned.
If \code{random=TRUE}, the weights are drawn uniformly from a Dirichlet distribution.

If inequalities are provided via \code{A} and \code{b}, linear programming (LP) is used
to find the Chebyshev center of the polytope (i.e., the center of the largest ball that
fits into the polytope; the solution may not be unique). If \code{random=TRUE},
LP is used to find a random point (not uniformly sampled!) in the convex polytope.
}
\examples{
# inequality representation (A*x <= b)
A <- matrix(
  c(
    1, -1, 0, 1, 0,
    0, 0, -1, 0, 1,
    0, 0, 0, 1, -1,
    1, 1, 1, 1, 0,
    1, 1, 1, 0, 0,
    -1, 0, 0, 0, 0
  ),
  ncol = 5, byrow = TRUE
)
b <- c(0.5, 0, 0, .7, .4, -.2)
find_inside(A, b)
find_inside(A, b, random = TRUE)


# vertex representation
V <- matrix(c(
  # strict weak orders
  0, 1, 0, 1, 0, 1, # a < b < c
  1, 0, 0, 1, 0, 1, # b < a < c
  0, 1, 0, 1, 1, 0, # a < c < b
  0, 1, 1, 0, 1, 0, # c < a < b
  1, 0, 1, 0, 1, 0, # c < b < a
  1, 0, 1, 0, 0, 1, # b < c < a

  0, 0, 0, 1, 0, 1, # a ~ b < c
  0, 1, 0, 0, 1, 0, # a ~ c < b
  1, 0, 1, 0, 0, 0, # c ~ b < a
  0, 1, 0, 1, 0, 0, # a < b ~ c
  1, 0, 0, 0, 0, 1, # b < a ~ c
  0, 0, 1, 0, 1, 0, # c < a ~ b

  0, 0, 0, 0, 0, 0 # a ~ b ~ c
), byrow = TRUE, ncol = 6)
find_inside(V = V)
find_inside(V = V, random = TRUE)
}
