% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_nodesplit-class.R
\name{summary.nma_nodesplit_df}
\alias{summary.nma_nodesplit_df}
\alias{summary.nma_nodesplit}
\alias{plot.nma_nodesplit}
\alias{plot.nma_nodesplit_df}
\title{Summarise the results of node-splitting models}
\usage{
\method{summary}{nma_nodesplit_df}(
  object,
  consistency = NULL,
  ...,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975)
)

\method{summary}{nma_nodesplit}(
  object,
  consistency = NULL,
  ...,
  probs = c(0.025, 0.25, 0.5, 0.75, 0.975)
)

\method{plot}{nma_nodesplit}(x, consistency = NULL, ...)

\method{plot}{nma_nodesplit_df}(x, consistency = NULL, ...)
}
\arguments{
\item{consistency}{Optional, a \code{stan_nma} object for the corresponding fitted
consistency model, to display the network estimates alongside the direct
and indirect estimates. The fitted consistency model present in the
\code{nma_nodesplit_df} object will be used if this is present (see
\code{\link[=get_nodesplits]{get_nodesplits()}}).}

\item{...}{Additional arguments passed on to other methods}

\item{probs}{Numeric vector of specifying quantiles of interest, default
\code{c(0.025, 0.25, 0.5, 0.75, 0.975)}}

\item{x, object}{A \code{nma_nodesplit} or \code{nma_nodesplit_df} object}
}
\value{
A \link{nodesplit_summary} object
}
\description{
Posterior summaries of node-splitting models (\code{nma_nodesplit} and
\code{nma_nodesplit_df} objects) can be produced using the \code{summary()} method, and
plotted using the \code{plot()} method.
}
\details{
The \code{plot()} method is a shortcut for \code{plot(summary(nma_nodesplit))}. For
details of plotting options, see \code{\link[=plot.nodesplit_summary]{plot.nodesplit_summary()}}.
}
\examples{
\donttest{
# Run smoking node-splitting example if not already available
if (!exists("smk_fit_RE_nodesplit")) example("example_smk_nodesplit", run.donttest = TRUE)
}
\donttest{
# Summarise the node-splitting results
summary(smk_fit_RE_nodesplit)

# Plot the node-splitting results
plot(smk_fit_RE_nodesplit)
}
}
\seealso{
\code{\link[=plot.nodesplit_summary]{plot.nodesplit_summary()}}
}
