% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data.R
\name{set_agd_arm}
\alias{set_agd_arm}
\title{Set up arm-based aggregate data}
\usage{
set_agd_arm(
  data,
  study,
  trt,
  y = NULL,
  se = NULL,
  r = NULL,
  n = NULL,
  E = NULL,
  sample_size = NULL,
  trt_ref = NULL,
  trt_class = NULL
)
}
\arguments{
\item{data}{a data frame}

\item{study}{column of \code{data} specifying the studies, coded using integers,
strings, or factors}

\item{trt}{column of \code{data} specifying treatments, coded using integers,
strings, or factors}

\item{y}{column of \code{data} specifying a continuous outcome}

\item{se}{column of \code{data} specifying the standard error for a continuous
outcome}

\item{r}{column of \code{data} specifying a binary or Binomial outcome count}

\item{n}{column of \code{data} specifying Binomial outcome numerator}

\item{E}{column of \code{data} specifying the total time at risk for Poisson
outcomes}

\item{sample_size}{column of \code{data} giving the sample size in each arm.
Optional, see details.}

\item{trt_ref}{reference treatment for the network, as a single integer,
string, or factor. If not specified, a reasonable well-connected default
will be chosen (see details).}

\item{trt_class}{column of \code{data} specifying treatment classes, coded using
integers, strings, or factors. By default, no classes are specified.}
}
\value{
An object of class \link{nma_data}
}
\description{
Set up a network containing arm-based aggregate data (AgD), such as event
counts or mean outcomes on each arm. Multiple data sources may be combined
once created using \code{\link[=combine_network]{combine_network()}}.
}
\details{
By default, \code{trt_ref = NULL} and a network reference treatment will be chosen
that attempts to maximise computational efficiency and stability. If an
alternative reference treatment is chosen and the model runs slowly or has
low effective sample size (ESS) this may be the cause - try letting the
default reference treatment be used instead. Regardless of which treatment is
used as the network reference at the model fitting stage, results can be
transformed afterwards: see the \code{trt_ref} argument of
\code{\link[=relative_effects]{relative_effects()}} and \code{\link[=predict.stan_nma]{predict.stan_nma()}}.

The \code{sample_size} argument is optional, but when specified:
\itemize{
\item Enables automatic centering of predictors (\code{center = TRUE}) in \code{\link[=nma]{nma()}}
when a regression model is given for a network combining IPD and AgD
\item Enables production of study-specific relative effects, rank probabilities,
etc. for studies in the network when a regression model is given
\item Nodes in \code{\link[=plot.nma_data]{plot.nma_data()}} may be weighted by sample size
}

If a Binomial outcome is specified and \code{sample_size} is omitted, \code{n} will be
used as the sample size by default.
}
\examples{
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net


# Plot network
plot(smk_net)
}
\seealso{
\code{\link[=set_ipd]{set_ipd()}} for individual patient data, \code{\link[=set_agd_contrast]{set_agd_contrast()}} for
contrast-based aggregate data, and \code{\link[=combine_network]{combine_network()}} for combining
several data sources in one network.

\code{\link[=print.nma_data]{print.nma_data()}} for the print method displaying details of the
network, and \code{\link[=plot.nma_data]{plot.nma_data()}} for network plots.
}
