% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_dic.R
\name{dic}
\alias{dic}
\title{Deviance Information Criterion (DIC)}
\usage{
dic(x, ...)
}
\arguments{
\item{x}{A fitted model object, inheriting class \link{stan_nma}}

\item{...}{Other arguments (not used)}
}
\value{
A \link{nma_dic} object.
}
\description{
Calculate the DIC for a model fitted using the \code{\link[=nma]{nma()}} function.
}
\examples{
## Smoking cessation
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

\donttest{
# Fitting a fixed effect model
smk_fit_FE <- nma(smk_net,
              trt_effects = "fixed",
              prior_intercept = normal(scale = 100),
              prior_trt = normal(scale = 100))

smk_fit_FE
}

\donttest{
# Fitting a random effects model
smk_fit_RE <- nma(smk_net,
                  trt_effects = "random",
                  prior_intercept = normal(scale = 100),
                  prior_trt = normal(scale = 100),
                  prior_het = normal(scale = 5))

smk_fit_RE
}

\donttest{
# Compare DIC of FE and RE models
(smk_dic_FE <- dic(smk_fit_FE))
(smk_dic_RE <- dic(smk_fit_RE))   # substantially better fit

# Plot residual deviance contributions under RE model
plot(smk_dic_RE)

# Check for inconsistency using UME model
}
\donttest{
# Fitting an unrelated mean effects (inconsistency) model
smk_fit_RE_UME <- nma(smk_net,
                      consistency = "ume",
                      trt_effects = "random",
                      prior_intercept = normal(scale = 100),
                      prior_trt = normal(scale = 100),
                      prior_het = normal(scale = 5))

smk_fit_RE_UME
}

\donttest{
# Compare DIC
smk_dic_RE
(smk_dic_RE_UME <- dic(smk_fit_RE_UME))  # no difference in fit

# Compare residual deviance contributions
plot(smk_dic_RE, smk_dic_RE_UME, show_uncertainty = FALSE)
}
}
\seealso{
\code{\link[=print.nma_dic]{print.nma_dic()}} for printing details, \code{\link[=plot.nma_dic]{plot.nma_dic()}} for
producing plots of residual deviance contributions.
}
