% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClosedSCR.R
\name{multimodelClosedSCR}
\alias{multimodelClosedSCR}
\title{Multimodel inference for 'multimark' spatial population abundance models}
\usage{
multimodelClosedSCR(modlist, modprior = rep(1/length(modlist),
  length(modlist)), monparms = "N", miter = NULL, mburnin = 0,
  mthin = 1, M1 = NULL, pbetapropsd = 1, sigpropmean = 0.8,
  sigpropsd = 0.4, printlog = FALSE)
}
\arguments{
\item{modlist}{A list of individual model output lists returned by \code{\link{multimarkClosedSCR}} or \code{\link{markClosedSCR}}. The models must have the same number of chains and MCMC iterations.}

\item{modprior}{Vector of length \code{length(modlist)} containing prior model probabilities. Default is \code{modprior = rep(1/length(modlist), length(modlist))}.}

\item{monparms}{Parameters to monitor. Only parameters common to all models can be monitored (e.g., "\code{pbeta[(Intercept)]}", "\code{N}", "\code{sigma2_scr}"), but derived density ("\code{D}") as well as capture ("\code{p}") and recapture ("\code{c}") probabilities (at distance zero from activity centers) can also be monitored. Default is \code{monparms = "N"}.}

\item{miter}{The number of RJMCMC iterations per chain. If \code{NULL}, then the number of MCMC iterations for each individual model chain is used.}

\item{mburnin}{Number of burn-in iterations (\code{0 <= mburnin < miter}).}

\item{mthin}{Thinning interval for monitored parameters.}

\item{M1}{Integer vector indicating the initial model for each chain, where \code{M1_j=i} initializes the RJMCMC algorithm for chain j in the model corresponding to \code{modlist[[i]]} for i=1,...,  \code{length(modlist)}. If \code{NULL}, the algorithm for all chains is initialized in the most general model. Default is \code{M1=NULL}.}

\item{pbetapropsd}{Scaler specifying the standard deviation of the Normal(0, pbetapropsd) proposal distribution for "\code{pbeta}"  parameters. Default is \code{pbetapropsd=1}. See Barker & Link (2013) for more details.}

\item{sigpropmean}{Scaler specifying the mean of the inverse Gamma proposal distribution for \code{sigma2_scr} (or \code{lambda} if \code{detection=``exponential''}). Only applies if models do not have the same detection function (i.e., ``half-normal'' or ``exponential''). Default is \code{sigpropmean=0.8}. See Barker & Link (2013) for more details.}

\item{sigpropsd}{Scaler specifying the standard deviation of the inverse Gamma proposal distribution for \code{sigma2_scr} (or \code{lambda} if \code{detection=``exponential''}). Only applies if models do not have the same detection function (i.e., ``half-normal'' or ``exponential''). Default is \code{sigpropsd=0.4}. See Barker & Link (2013) for more details.}

\item{printlog}{Logical indicating whether to print the progress of chains and any errors to a log file in the working directory. Ignored when \code{nchains=1}. Updates are printed to log file as 1\% increments of \code{iter} of each chain are completed. With >1 chains, setting \code{printlog=TRUE} is probably most useful for Windows users because progress and errors are automatically printed to the R console for "Unix-like" machines (i.e., Mac and Linux) when \code{printlog=FALSE}. Default is \code{printlog=FALSE}.}
}
\value{
A list containing the following:
\item{rjmcmc}{Reversible jump Markov chain Monte Carlo object of class \code{\link[coda]{mcmc.list}}. Includes RJMCMC output for monitored parameters and the current model at each iteration ("\code{M}").}
\item{pos.prob}{A list of calculated posterior model probabilities for each chain, including the overall posterior model probabilities across all chains.}
}
\description{
This function performs Bayesian multimodel inference for a set of 'multimark' spatial population abundance models using the reversible jump Markov chain Monte Carlo (RJMCMC) algorithm proposed by Barker & Link (2013).
}
\details{
Note that setting \code{parms="all"} is required when fitting individual \code{\link{multimarkClosedSCR}} or \code{\link{markClosedSCR}} models to be included in \code{modlist}.
}
\examples{
\dontshow{
sim.data<-simdataClosedSCR()
Enc.Mat<-sim.data$Enc.Mat
trapCoords<-sim.data$spatialInputs$trapCoords
studyArea<-sim.data$spatialInputs$studyArea
setup<-processdataSCR(Enc.Mat,trapCoords,studyArea)
test.dot<-multimarkClosedSCR(mms=setup,parms="all",iter=10,burnin=0,bin=5)
test<-multimodelClosedSCR(modlist=list(mod1=test.dot,mod2=test.dot))
}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Generate object of class "multimarkSCRsetup"
sim.data<-simdataClosedSCR()
Enc.Mat<-sim.data$Enc.Mat
trapCoords<-sim.data$spatialInputs$trapCoords
studyArea<-sim.data$spatialInputs$studyArea
setup<-processdataSCR(Enc.Mat,trapCoords,studyArea)
 
#Run single chain using the default model for simulated data. Note parms="all".
example.dot <- multimarkClosedSCR(mms=setup,parms="all",iter=1000,adapt=500,burnin=500)

#Run single chain for simulated data with behavior effects. Note parms="all".
example.c <- multimarkClosedSCR(mms=setup,mod.p=~c,parms="all",iter=1000,adapt=500,burnin=500)

#Perform RJMCMC using defaults
modlist <- list(mod1=example.dot,mod2=example.c)
example.M <- multimodelClosedSCR(modlist=modlist,monparms=c("N","D","sigma2_scr"))

#Posterior model probabilities
example.M$pos.prob
 
#multimodel posterior summary for abundance and density
summary(example.M$rjmcmc[,c("N","D")])}

}
\references{
Barker, R. J. and Link. W. A. 2013. Bayesian multimodel inference by RJMCMC: a Gibbs sampling approach. The American Statistician 67: 150-156.
}
\seealso{
\code{\link{multimarkClosedSCR}}, \code{\link{processdataSCR}}
}
\author{
Brett T. McClintock
}
