\name{FCPCA}
\alias{FCPCA}
\title{Flury's Common Principal Component Analysis}
\usage{
  FCPCA(Data, Group, Scale = FALSE, graph = FALSE)
}
\arguments{
  \item{Data}{a numeric matrix or data frame}

  \item{Group}{a vector of factors associated with group
  structure}

  \item{Scale}{scaling variables, by default is False. By
  default data are centered within groups.}

  \item{graph}{should loading and component be plotted}
}
\value{
  list with the following results:

  \item{Data}{original data}

  \item{Con.Data}{Concatenated centered data}

  \item{split.Data}{Group centered data}

  \item{Group}{Group as a factor vector}

  \item{loadings.common}{Matrix of common loadings}

  \item{lambda}{The specific variances of group}

  \item{exp.var}{Percentages of total variance recovered
  associated with each dimension }
}
\description{
  Common principal component Analysis
}
\examples{
Data = iris[,-5]
Group = iris[,5]
res.FCPCA = FCPCA(Data, Group, graph=TRUE)
loadingsplot(res.FCPCA, axes=c(1,2))
scoreplot(res.FCPCA, axes=c(1,2))
}
\references{
  B. N. Flury (1984). Common principal components in k
  groups.  \emph{Journal of the American Statistical
  Association}, 79, 892-898.

  A. Eslami, E. M. Qannari, A. Kohler and S. Bougeard
  (2013). General overview of methods of analysis of
  multi-group datasets, \emph{Revue des Nouvelles
  Technologies de l'Information}, 25, 108-123.
}
\seealso{
  \code{\link{mgPCA}}, \code{\link{DGPA}},
  \code{\link{DCCSWA}}, \code{\link{DSTATIS}},
  code{\link{BGC}}, code{\link{summarize}},
  code{\link{TBWvariance}}, \code{\link{loadingsplot}},
  \code{\link{scoreplot}}, \code{\link{iris}}
}

