% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_sampling_binom.R
\name{binom_tsampling}
\alias{binom_tsampling}
\title{Samples From Truncated Beta Densities}
\usage{
binom_tsampling(
  inequalities,
  index = 1,
  niter = 10000,
  prior = FALSE,
  nburnin = niter * 0.05,
  seed = NULL
)
}
\arguments{
\item{inequalities}{list that contains inequality constraints for each independent inequality constrained hypotheses. The list
is created in the \code{\link{generate_restriction_list}} function}

\item{index}{numeric. If multiple independent inequality constraints are specified, this index determines for which
inequality constraint samples should be drawn. Must be a single value. Default is 1}

\item{niter}{numeric. A single value specifying the number of samples. Default is set to \eqn{10,000}}

\item{prior}{logical. If \code{TRUE} ignores the data that are encoded in \code{inequalities} and thus samples from the
prior distribution. Default is \code{FALSE}.}

\item{nburnin}{numeric. A single value specifying the number of burn-in samples when drawing from the truncated distribution.
Minimum number of burn-in samples is 10. Default is 5\% of the number of samples. Burn-in samples are removed automatically after the sampling.}

\item{seed}{numeric. Sets the seed for reproducible pseudo-random number generation}
}
\value{
matrix of dimension \code{niter * nsamples} containing samples from truncated beta distributions.
}
\description{
Based on specified inequality constraints, samples from truncated
prior or posterior beta densities.
}
\details{
The model assumes that the data in \code{x} (i.e., \eqn{x_1, ..., x_K}) are the observations of \eqn{K} independent
binomial experiments, based on \eqn{n_1, ..., n_K} observations. Hence, the underlying likelihood is the product of the
\eqn{k = 1, ..., K} individual binomial functions:
\deqn{(x_1, ... x_K) ~ \prod Binomial(N_k, \theta_k)}
Furthermore, the model assigns a beta distribution as prior to each model parameter
(i.e., underlying binomial proportions). That is:
\deqn{\theta_k ~ Beta(\alpha_k, \beta_k)}
}
\note{
When equality constraints are specified in the restricted hypothesis, this function samples from the conditional
Beta distributions given that the equality constraints hold.

Only inequality constrained parameters are sampled. Free parameters or parameters that are
exclusively equality constrained will be ignored.
}
\examples{
x <- c(200, 130, 40, 10)
n <- c(200, 200, 200, 200)
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
factor_levels <- c('binom1', 'binom2', 'binom3', 'binom4')
Hr <- c('binom1 > binom2 > binom3 > binom4')

# generate restriction list
inequalities <- generate_restriction_list(x=x, n=n, Hr=Hr, a=a, b=b, 
factor_levels=factor_levels)$inequality_constraints

# sample from prior distribution
prior_samples <- binom_tsampling(inequalities, niter = 500, 
prior=TRUE)
# sample from posterior distribution
post_samples <- binom_tsampling(inequalities, niter = 500)
}
\references{
\insertRef{damien2001sampling}{multibridge}
}
\seealso{
\code{\link{generate_restriction_list}}
}
\concept{functions to sample from truncated densities}
