% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosa_results.R
\name{rosa_results}
\alias{rosa_results}
\alias{predict.rosa}
\alias{rosa.classify}
\alias{coef.rosa}
\alias{print.rosa}
\alias{summary.rosa}
\alias{blockexpl}
\alias{print.rosaexpl}
\alias{scores.rosa}
\alias{loadings.rosa}
\title{Result functions for ROSA models}
\usage{
\method{predict}{rosa}(
  object,
  newdata,
  ncomp = 1:object$ncomp,
  comps,
  type = c("response", "scores"),
  na.action = na.pass,
  ...
)

\method{coef}{rosa}(object, ncomp = object$ncomp, comps, intercept = FALSE, ...)

\method{print}{rosa}(x, ...)

\method{summary}{rosa}(
  object,
  what = c("all", "validation", "training"),
  digits = 4,
  print.gap = 2,
  ...
)

blockexpl(object, ncomp = object$ncomp, type = c("train", "CV"))

\method{print}{rosaexpl}(x, digits = 3, compwise = FALSE, ...)

rosa.classify(object, classes, newdata, ncomp, LQ)

\method{scores}{rosa}(object, ...)

\method{loadings}{rosa}(object, ...)
}
\arguments{
\item{object}{A \code{rosa} object.}

\item{newdata}{Optional new data with the same types of predictor blocks as the ones used for fitting the object.}

\item{ncomp}{An \code{integer} giving the number of components to use apply.}

\item{comps}{An \code{integer} vector giving the exact components to apply.}

\item{type}{Character indicating which type of explained variance to compute (default = "train", alternative = "CV").}

\item{na.action}{Function determining what to do with missing values in \code{newdata}.}

\item{...}{Additional arguments. Currently not implemented.}

\item{intercept}{A \code{logical} indicating if coefficients for the intercept should be included (default = FALSE).}

\item{x}{A \code{rosa} object.}

\item{what}{A \code{character} indicating if summary should include all, validation or training.}

\item{digits}{The number of digits used for printing.}

\item{print.gap}{Gap between columns when printing.}

\item{compwise}{Logical indicating if block-wise (default/FALSE) or component-wise (TRUE) explained variance should be printed.}

\item{classes}{A \code{character} vector of class labels.}

\item{LQ}{A \code{character} indicating if 'max' (maximum score value), 'lda' or 'qda' should be used when classifying.}
}
\value{
Returns depend on method used, e.g. \code{predict.rosa} returns predicted responses
or scores depending on inputs, \code{coef.rosa} returns regression coefficients, \code{blockexpl}
returns an object of class \code{rosaexpl} containing block-wise and component-wise explained variance contained in a matrix with attributes.
}
\description{
Standard result computation and extraction functions for ROSA (\code{\link{rosa}}).
}
\details{
Usage of the functions are shown using generics in the examples below.
Prediction, regression coefficients, object printing and summary are available through:
\code{predict.rosa},  \code{coef.rosa}, \code{print.rosa} and \code{summary.rosa}.
Explained variances are available (block-wise and global) through \code{blockexpl} and \code{print.rosaexpl}.
Scores and loadings have their own extensions of \code{scores()} and \code{loadings()} throught
\code{scores.rosa} and \code{loadings.rosa}. Finally, there is work in progress on classifcation
support through \code{rosa.classify}.
}
\examples{
data(potato)
mod <- rosa(Sensory[,1] ~ ., data = potato, ncomp = 5, subset = 1:20)
testset <- potato[-(1:20),]; testset$Sensory <- testset$Sensory[,1,drop=FALSE]
predict(mod, testset, ncomp=5)
dim(coef(mod, ncomp=5)) # <variables x responses x components>
print(mod)
summary(mod)
blockexpl(mod)
print(blockexpl(mod), compwise=TRUE)

}
\references{
Liland, K.H., Næs, T., and Indahl, U.G. (2016). ROSA - a fast extension of partial least squares regression for multiblock data analysis. Journal of Chemometrics, 30, 651–662, doi:10.1002/cem.2824.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{rosa_results}} and \code{\link{rosa_plots}}, respectively.
}
