% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised.R
\name{smbpls}
\alias{smbpls}
\title{Sparse Multiblock Partial Least Squares - sMB-PLS}
\usage{
smbpls(
  formula,
  data,
  subset,
  na.action,
  X = NULL,
  Y = NULL,
  ncomp = 1,
  scale = FALSE,
  shrink = NULL,
  truncation = NULL,
  trunc.width = 0.95,
  ...
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictor block names separated by + signs.}

\item{data}{The data set to analyse.}

\item{subset}{Expression for subsetting the data before modelling.}

\item{na.action}{How to handle NAs (no action implemented).}

\item{X}{\code{list} of input blocks. If X is supplied, the formula interface is skipped.}

\item{Y}{\code{matrix} of responses.}

\item{ncomp}{\code{integer} number of PLS components.}

\item{scale}{\code{logical} for autoscaling inputs (default = FALSE).}

\item{shrink}{\code{numeric} scalar indicating degree of L1-shrinkage/Soft-Thresholding (optional), 0 <= shrink < 1.}

\item{truncation}{\code{character} indicating type of truncation (optional) "Lenth" uses
asymmetric confidence intervals to determine outlying loading weights. "quantile" uses
a quantile plot approach to determining outliers.}

\item{trunc.width}{\code{numeric} indicating confidence of "Lenth type" confidence interval
or quantile in "quantile plot" approach. Default = 0.95.}

\item{...}{additional arguments to pls::plsr.}
}
\value{
\code{multiblock, mvr} object with super-scores, super-loadings, block-scores and block-loading, and the underlying
\code{mvr} (PLS) object for the super model, with all its result and plot possibilities. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
sMB-PLS is an adaptation of MB-PLS (\code{\link{mbpls}}) that enforces sparseness in loading weights
when computing PLS components in the global model.
}
\details{
Two versions of sparseness are supplied: Soft-Threshold PLS, also
known as Sparse PLS, and Truncation PLS. The former uses L1 shrinkage of loading weights, while the latter
comes in two flavours, both estimating inliers and outliers. The "Lenth" method uses asymmetric confidence
intervals around the median of a loading weigh vector to estimate inliers. The "quantile" method uses
a quantile plot approach to estimate outliers as deviations from the estimated quantile line. As with
ordinary MB-PLS scaled input blocks (1/sqrt(ncol)) are used.
}
\examples{
data(potato)

# Truncation MB-PLS 
# Loading weights inside 60\% confidence intervals around the median are set to 0.
tmb <- smbpls(Sensory ~ Chemical+Compression, data=potato, ncomp = 5, 
              truncation = "Lenth", trunc.width = 0.6)
# Alternative XY-interface
tmb.XY <- smbpls(X=potato[c('Chemical','Compression')], Y=potato[['Sensory']], ncomp = 5, 
              truncation = "Lenth", trunc.width = 0.6)
identical(tmb, tmb.XY)
scoreplot(tmb, labels="names") # Exploiting mvr object structure from pls package
loadingweightplot(tmb, labels="names")

# Soft-Threshold / Sparse MB-PLS 
# Loading weights are subtracted by 60\% of maximum value.
smb <- smbpls(X=potato[c('Chemical','Compression')], Y=potato[['Sensory']], 
              ncomp = 5, shrink = 0.6)
print(smb)
scoreplot(smb, labels="names") # Exploiting mvr object structure from pls package
loadingweightplot(smb, labels="names")
}
\references{
\itemize{
\item Sæbø, S.; Almøy, T.; Aarøe, J. & Aastveit, A. ST-PLS: a multi-directional nearest shrunken centroid type classifier via PLS Journal of Chemometrics: A Journal of the Chemometrics Society, Wiley Online Library, 2008, 22, 54-62.
\item Lê Cao, K.; Rossouw, D.; Robert-Granié, C. & Besse, P. A sparse PLS for variable selection when integrating omics data Statistical applications in genetics and molecular biology, 2008, 7.
\item Liland, K.; Høy, M.; Martens, H. & Sæbø, S. Distribution based truncation for variable selection in subspace methods for multivariate regression Chemometrics and Intelligent Laboratory Systems, 2013, 122, 103-111.
\item Karaman, I.; Nørskov, N.; Yde, C.; Hedemann, M.; Knudsen, K. & Kohler, A. Sparse multi-block PLSR for biomarker discovery when integrating data from LC--MS and NMR metabolomics Metabolomics, 2015, 11, 367-379.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
