% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rn_floorNorm.R
\docType{class}
\name{Rn_floorNorm-class}
\alias{Rn_floorNorm-class}
\alias{Rn_floorNorm}
\title{An S4 class to represent the function \eqn{\frac{\Gamma(n/2+1)}{\pi^{n/2}(1+\lfloor \Vert \vec{x} \Vert_2^n \rfloor)^s}} on \eqn{R^n}}
\description{
Implementation of the function
\deqn{f \colon R^n \to [0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \frac{\Gamma(n/2+1)}{\pi^{n/2}(1+\lfloor \Vert \vec{x} \Vert_2^n \rfloor)^s},}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{R^n = \times_{i=1}^n R} and \eqn{s>1} is a parameter.
In this case the integral is know to be
\deqn{\int_{R^n} f(\vec{x}) d\vec{x} = \zeta(s),}
where \eqn{\zeta(s)} is the Riemann zeta function.
}
\details{
The instance needs to be created with two parameters representing \eqn{n} and \eqn{s}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}

\item{\code{s}}{A numeric value bigger than 1 representing a power}
}}

\examples{
n <- as.integer(3)
f <- new("Rn_floorNorm",dim=n,s=2)
}
\author{
Klaus Herrmann
}
