
#' Alta Lake Gravity Core Data
#' 
#' Bulk geochemistry of a gravity core from Alta Lake, Whistler, British Columbia,
#' Canada.
#' 
#' @format A [mudata] object
#' 
#' @references
#' Dunnington DW, Spooner IS, White CE, et al (2016) A geochemical perspective on the impact of 
#' development at Alta Lake, British Columbia, Canada. J Paleolimnol 56:315-330. 
#' [doi:10.1007/s10933-016-9919-x](https://doi.org/10.1007/s10933-016-9919-x)
#' 
#' @examples
#' print(alta_lake)
#' 
"alta_lake"

#' Long Lake Lake Gravity/Percussion Core Data
#' 
#' Bulk geochemistry of a gravity core from Long Lake, Cumberland Marshes Region, 
#' Nova Scotia-New Brunswick Border Region, Canada.
#' 
#' @format A [mudata] object
#' 
#' @references
#' Dunnington DW, White H, Spooner IS, et al (2017) A paleolimnological archive of metal 
#' sequestration and release in the Cumberland Basin Marshes, Atlantic Canada. FACETS 2:440-460. 
#' [doi:10.1139/facets-2017-0004](https://doi.org/10.1139/facets-2017-0004)

#' 
#' @examples
#' print(long_lake)
#' 
"long_lake"

#' Pockwock Lake/Lake Major Elemental Sample Data
#'
#' A small example data.frame used to test structure methods.
#'
#' @format A `data.frame` containing multi-qualifier concentration data
"pocmaj"

#'  Pre-summarised Sample Data
#'
#' A small example data.frame of pre-summarised data; a summarised
#' version of the [pocmaj] dataset.
#'
#' @format A `data.frame` containing multi-qualifier data
"pocmajsum"

#' Kentville/Greenwood Climate Data
#'
#' Climate data for Kentville and Greenwood (Nova Scotia) for July and August of 1999.
#'
#' @format A [mudata] object
#' 
#' @source Environment Canada via the 'rclimateca' package. <http://climate.weather.gc.ca/>
#' 
#' @examples
#' print(kentvillegreenwood)
#' 
"kentvillegreenwood"

#' Nova Scotia Long-Term Climate Data
#'
#' Monthly climate data for locations in Nova Scotia with records longer than 80 years.
#'
#' @format A [mudata] object
#' 
#' @source Environment Canada: <http://climate.weather.gc.ca/>
#' 
#' @examples
#' print(ns_climate)
#' 
"ns_climate"

#' Second Lake Thermistor String Data
#' 
#' Temperatures at multiple depths in the water column for a season at Second Lake, Lower Sackville, 
#' Nova Scotia, Canada.
#' 
#' @format A [mudata] object
#' 
#' @references
#' Misiuk B (2014) A multi-proxy comparative paleolimnological study of anthropogenic 
#' impact between First and Second Lake, Lower Sackville, Nova Scotia. 
#' B.Sc.H. Thesis, Acadia University. <http://scholar.acadiau.ca/islandora/object/theses:1148>
#' 
#' @examples
#' print(second_lake_temp)
#' 
"second_lake_temp"
