% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeOutliers.R
\name{removeOutliers}
\alias{removeOutliers}
\title{removeOutliers}
\usage{
removeOutliers(outlier_cells, hvt_results)
}
\arguments{
\item{outlier_cells}{Vector. A vector with the cell number of the identified outliers}

\item{hvt_results}{List. A list having the results of the compressed map i.e. output of \code{HVT} function}
}
\value{
A list of two items: a map having the data of removed outlier cells and the subset of  the dataset without outlier(s) which
has to be passed as input argument to \code{HVT} function to generate another map
\item{[[1]] }{Dataframe. Information about the removed outlier cell(s)}
\item{[[2]] }{Dataframe. Subset of dataset without the outlier cell(s)}
}
\description{
Remove identified outlier cell(s) from the dataset
}
\details{
This function is used to remove the identified outlier cell(s) from the dataset.
It is recommended to run the \code{HVT} function before running this function. It takes input in the form 
of cell number of the outlier cell(s) identified using the output of the \code{HVT} function and
the compressed map (hvt_mapA) generated using the \code{HVT} function. The output of this function is
a list of two items: a new map having the data of removed outlier cell(s) and the subset of dataset without outliers.
}
\examples{
data(USArrests)
hvt_mapA <- list()
hvt_mapA <- HVT(USArrests, min_compression_perc = 70, quant.err = 0.2, 
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE,
                   quant_method="kmeans")
plotHVT(hvt_mapA, line.width = c(0.8), color.vec = c('#141B41'), 
        maxDepth = 1)
        
identified_outlier_cells <- c(2, 10)
output_list <- removeOutliers(identified_outlier_cells, hvt_mapA)
hvt_mapB <- output_list[[1]]
dataset_without_outliers <- output_list[[2]]

}
\seealso{
\code{\link{HVT}} \cr \code{\link{mlayerHVT}}
}
\author{
Shantanu Vaidya <shantanu.vaidya@mu-sigma.com>
}
