% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploded_hmap.R
\name{exploded_hmap}
\alias{exploded_hmap}
\title{Function to construct an interactive 3D heatmap overlay for each HVT Level}
\usage{
exploded_hmap(
  hvt.results,
  child.level = NULL,
  hmap.cols = NULL,
  n_cells.hmap = NULL,
  sepration_width = 7,
  layer_opacity = c(0.5, 0.75, 0.99),
  dim_size = 1000,
  ...
)
}
\arguments{
\item{hvt.results}{List. A list of hvt.results obtained from the HVT
function.}

\item{child.level}{Numeric. Indicating the level for which the heat map is
to be plotted.}

\item{hmap.cols}{Numeric or Character. The column number of column name from
the dataset indicating the variables for which the heat map is to be
plotted.}

\item{n_cells.hmap}{Numeric. An integer indicating the number of clusters per
hierarchy (level)}

\item{sepration_width}{Numeric. An integer indicating the width between two Levels}

\item{layer_opacity}{Numeric. A vector indicating the opacity of each layer/ level}

\item{dim_size}{Numeric. An integer indicating the dimension size used to create the matrix for the plot}

\item{...}{color.vec and line.width can be passed from here}
}
\description{
Function to construct an interactive 3D heatmap overlay for each HVT Level
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
