% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{class}
\name{Cube}
\alias{Cube}
\title{Extract a MicroStrategy cube into a R Data.Frame}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Cube
}
\description{
Access, filter, publish, and extract data from MicroStrategy in-memory cubes
}
\section{Fields}{

\describe{
\item{\code{connection}}{MicroStrategy connection object}

\item{\code{cube_id}}{Identifier of a cube.}
}}

\examples{
\donttest{
my_cube <- Cube$new(connection=conn, cube_id="...")
df <- my_cube$to_dataframe()
# Use object IDs for metrics, attributes, and attribute elements to filter contents of a cube.
my_cube$metrics
my_cube$attributes
my_cube$attr_elements

# Then, choose those elements by passing their IDs to the Cube.apply_filters() method. To see 
# the chosen elements, call my_cube.filters and to clear any active filters, 
# call my_cube.clear_filters().
my_cube$apply_filters(
         attributes=list("A598372E11E9910D1CBF0080EFD54D63", "A59855D811E9910D1CC50080EFD54D63"),
         metrics=list("B4054F5411E9910D672E0080EFC5AE5B"),
         attr_elements=list("A598372E11E9910D1CBF0080EFD54D63:Los Angeles", 
         "A598372E11E9910D1CBF0080EFD54D63:Seattle"))
df <- my_cube$to_dataframe()
}
}
\keyword{datasets}
