% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{regparasearch}
\alias{regparasearch}
\alias{print.regparasearch}
\title{Regularized Parameters Search}
\usage{
regparasearch(X, Y = NULL, Z = NULL, eta = 1, type = "lasso",
  inX = NULL, inY = NULL, inXsup = NULL, inYsup = NULL, muX = 0,
  muY = 0, comp = 1, nfold = 5, maxrep = 3, minpct = 0,
  maxpct = 1, method = c("CV", "BIC")[1], whichselect = NULL,
  homo = NULL)

\method{print}{regparasearch}(x, ...)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s).}

\item{Y}{a (list of) matrix, objective variable(s).}

\item{Z}{a (list of) matrix, response variable(s).}

\item{eta}{numeric scalar the parameter indexing the penalty family.}

\item{type}{a character.}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inXsup}{a (list of) numeric vector to specify the blocks of X which are always in the model.}

\item{inYsup}{a (list of) numeric vector to specify the blocks of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised.}

\item{muY}{a numeric scalar for the weight of Y for the supervised.}

\item{comp}{numeric scalar for the maximum number of componets to be considered.}

\item{nfold}{number of folds - default is 5.}

\item{maxrep}{numeric scalar for the number of iteration.}

\item{minpct}{percent of minimum candidate parameters.}

\item{maxpct}{percent of maximum candidate parameters.}

\item{method}{a character, the evaluation criterion, "CV" for cross-validation, based on a matrix element-wise error, and "BIC" for Bayesian information criteria. The "BIC" is the default.}

\item{whichselect}{which blocks selected.}

\item{homo}{same parameters.}

\item{x}{an object of class "\code{regparasearch}", usually, a result of a call to \code{\link{regparasearch}}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{optlambdaX}{Optimal parameters for X}

\item{optlambdaY}{Optimal parameters for Y}

\item{mincriterion}{Minimum of criterion values}

\item{criterions}{Resulting criterion value}

\item{pararange}{Range of candidates parameters}
}
\description{
Regularized parameters search method for "msma".
}
\details{
Regularized parameters search for \code{msma}
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = c(20, 15), seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### Regularized parameters search #####
opt1 = regparasearch(X, Y, comp=1, method="BIC", maxrep=2, whichselect=c("X", "Y", "Xsup", "Ysup"))
opt1
fit4 = msma(X, Y, comp=1, lambdaX=opt1$optlambdaX, lambdaY=opt1$optlambdaY, 
lambdaXsup=opt1$optlambdaXsup, lambdaYsup=opt1$optlambdaYsup)
fit4
summary(fit4)

}
