% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{ncompsearch}
\alias{ncompsearch}
\alias{print.ncompsearch}
\alias{plot.ncompsearch}
\title{Search for Number of Components}
\usage{
ncompsearch(X, Y = NULL, Z = NULL, comps = 1:3, lambdaX = NULL,
  lambdaY = NULL, lambdaXsup = NULL, lambdaYsup = NULL, eta = 1,
  type = "lasso", inX = NULL, inY = NULL, inXsup = NULL,
  inYsup = NULL, muX = 0, muY = 0, nfold = 5, regpara = FALSE,
  maxrep = 3, method = c("CV", "BIC")[1], whichselect = NULL)

\method{print}{ncompsearch}(x, ...)

\method{plot}{ncompsearch}(x, ...)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s).}

\item{Y}{a (list of) matrix, objective variable(s).}

\item{Z}{a (list of) matrix, response variable(s).}

\item{comps}{numeric vector for the maximum numbers of componets to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaXsup}{numeric vector of regularized parameters for the super weight of X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaYsup}{numeric vector of regularized parameters for the super weight of Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar the parameter indexing the penalty family.}

\item{type}{a character.}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inXsup}{a (list of) numeric vector to specify the blocks of X which are always in the model.}

\item{inYsup}{a (list of) numeric vector to specify the blocks of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised.}

\item{muY}{a numeric scalar for the weight of Y for the supervised.}

\item{nfold}{number of folds - default is 5.}

\item{regpara}{logical}

\item{maxrep}{numeric scalar for the number of iteration.}

\item{method}{a character, the evaluation criterion, "CV" for cross-validation, based on a matrix element-wise error, and "BIC" for Bayesian information criteria. The "BIC" is the default.}

\item{whichselect}{which blocks selected.}

\item{x}{an object of class "\code{ncompsearch}", usually, a result of a call to \code{\link{ncompsearch}}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{comps}{numbers of components}

\item{mincriterion}{minimum criterion values}

\item{criterions}{criterion values}

\item{optncomp}{optimal number of components based on minimum cross-validation error}
}
\description{
cross-validated method to determine the number of components.
}
\details{
k-fold cross-validation for \code{msma}
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### number of components search #####
ncomp1 = ncompsearch(X, Y, comps = c(1, 5, 10*(1:2)), nfold=5)
plot(ncomp1)

}
