% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncotree_to_nci.R
\name{oncotree_to_nci}
\alias{oncotree_to_nci}
\title{Map OncoTree to NCIt codes}
\usage{
oncotree_to_nci(
  oncotree_code = NULL,
  oncotree_version = "oncotree_latest_stable",
  expand = FALSE,
  keep_empty = TRUE
)
}
\arguments{
\item{oncotree_code}{OncoTree codes.}

\item{oncotree_version}{OncoTree database release version.}

\item{expand}{Whether to expand one-to-many mappings. If \code{TRUE}, one-to-many mappings are expanded into several rows in the output.}

\item{keep_empty}{OncoTree codes that do not map to NCI have the \code{nci_code} with \code{NA} if \code{keep_empty = TRUE}. Use \code{keep_empty = FALSE}, to remove the mapping (row) altogether from the output.}
}
\value{
A \link[tibble:tibble-package]{tibble} of two variables: \code{oncotree_code} and \code{nci_code}.
}
\description{
This function maps OncoTree codes to  National Cancer Institute Thesaurus (NCIt) codes.
}
\examples{
# Leave `oncotree_code` empty to return mappings for all OncoTree codes
oncotree_to_nci()

# Map a few selected OncoTree codes
oncotree_to_nci(oncotree_code = c('PAOS', 'SCST', 'ITLPDGI', 'SRCCR'))

# Use `expand` to make sure the column `nci_code` is a character vector and
# not a list-column. One-to-many mappings will result in more than row with
# `oncotree_code` values repeated.
oncotree_to_nci(oncotree_code = c('PAOS', 'SCST', 'ITLPDGI', 'SRCCR'), expand
= TRUE)

# Use `keep_empty` to drop or keep one-to-none mappings
oncotree_to_nci(oncotree_code = c('PAOS', 'SCST', 'ITLPDGI', 'SRCCR'), expand
= TRUE, keep_empty = FALSE)

}
