\name{coef.msgl}
\alias{coef.msgl}
\title{Extract nonzero coefficients}
\usage{
  \method{coef}{msgl} (object, index = 1:nmod(object), ...)
}
\arguments{
  \item{object}{a msgl object}

  \item{index}{indices of the models}

  \item{...}{ignored}
}
\value{
  a list of length \code{length(index)} with nonzero
  coefficients of the models
}
\description{
  Extract nonzero coefficients
}
\examples{
data(SimData)
x <- sim.data$x
classes <- sim.data$classes
lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x, classes, alpha = .5, lambda = lambda)

# the nonzero coefficients of the models 1, 10 and 20
coef(fit, index = c(1,10,20))
}
\author{
  Martin Vincent
}

