\name{martTrain}
\alias{martTrain}
\title{ train using MART }
\description{
 Train the MART model.
}
\usage{
martTrain(data, shrinkage = 0.06, interaction.depth = 10, n.trees = 2000, small_count = 0.5)
}
\arguments{
  \item{data}{ the data frame generated by \code{expData.R} }
  \item{shrinkage}{ the \code{shrinkage} argument of gbm }
  \item{interaction.depth}{ the \code{interaction.depth} argument of gbm }
  \item{n.trees}{ the \code{n.trees} argument of gbm }
  \item{small_count}{ the small count which will replace the zero count }
}
\value{
 a gbm object
}
\examples{
 # read and expand the data
 data(g1_part) # for real data, please use read.csv, like g1 <- read.csv("g1.csv")
 data <- expData(g1_part, 2, 3)
 
 data.mart <- martTrain(data, interaction.depth = 2, n.trees = 100)
}
\keyword{ models }
\keyword{ tree }
